/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long bytesWritten = 0L;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    public OutputStream getUnderlyingOutputStream() {
        return this.out;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.bytesWritten;
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.bytesWritten += (long)len;
        this.out.write(b, off, len);
    }
}

