/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.io;

import com.cognos.cm.diagnostics.Timer;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class TimedReader
extends FilterReader {
    private final Timer timer;

    public TimedReader(Reader src, Timer timer) {
        super(src);
        this.timer = timer;
    }

    @Override
    public int read() throws IOException {
        this.timer.start();
        try {
            int n = this.in.read();
            return n;
        }
        finally {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.timer.start();
        try {
            int n = this.in.read(cbuf, off, len);
            return n;
        }
        finally {
            this.timer.stop();
        }
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        this.timer.start();
        try {
            int n = this.in.read(cbuf);
            return n;
        }
        finally {
            this.timer.stop();
        }
    }
}

