/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.stax;

import com.cognos.cm.util.stax.PathParser;
import java.util.List;

public class Path {
    private String variable;
    private String[] path;

    public Path(String variableName, PathParser pathParser) {
        this.variable = variableName;
        this.path = pathParser.getSteps();
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    private String[] getMatchPath() {
        return this.path;
    }

    public boolean pathMatches(List<String> testPath) {
        if (!this.thereAreSteps(testPath)) {
            return false;
        }
        String[] elements = this.getMatchPath();
        if (!this.pathSizesMatch(testPath, elements)) {
            return false;
        }
        return this.stepsMatch(testPath, elements);
    }

    private boolean stepsMatch(List<String> testPath, String[] path) {
        for (int i = path.length - 1; i >= 0; --i) {
            if (testPath.get(i).equals(path[i])) continue;
            return false;
        }
        return true;
    }

    private boolean pathSizesMatch(List<String> testPath, String[] path) {
        return path.length == testPath.size();
    }

    private boolean thereAreSteps(List<String> steps) {
        return steps.size() > 0;
    }
}

