/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.stax;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class PathDelegate
extends StreamReaderDelegate {
    private final List<String> steps;
    private boolean foundValue;
    private int currentPos;
    private boolean writeChars;
    private StringBuilder valueBuilder;

    public PathDelegate(XMLStreamReader staxXMLReader, List<String> steps) {
        super(staxXMLReader);
        this.steps = steps;
        this.currentPos = 0;
        this.foundValue = false;
        this.writeChars = false;
    }

    @Override
    public int next() throws XMLStreamException {
        int event = super.next();
        if (this.stillSearching()) {
            switch (event) {
                case 1: {
                    String localName = this.getLocalName();
                    if (!this.searchingFor(localName)) break;
                    if (this.lastStep()) {
                        this.writeChars = true;
                        break;
                    }
                    this.nextStep();
                    break;
                }
                case 4: {
                    if (!this.writeChars) break;
                    this.getStringBuilder().append(this.getText());
                    break;
                }
                case 2: {
                    if (!this.searchingFor(this.getLocalName()) || !this.lastStep()) break;
                    this.writeChars = false;
                    this.foundValue = true;
                }
            }
        }
        return event;
    }

    private StringBuilder getStringBuilder() {
        if (this.valueBuilder == null) {
            this.valueBuilder = new StringBuilder();
        }
        return this.valueBuilder;
    }

    private void nextStep() {
        ++this.currentPos;
    }

    private boolean lastStep() {
        return this.currentPos == this.steps.size() - 1;
    }

    private boolean searchingFor(String localName) {
        return this.steps.get(this.currentPos).equals(localName);
    }

    public String getValue() {
        if (this.valueBuilder == null) {
            return null;
        }
        return this.valueBuilder.toString();
    }

    private boolean stillSearching() {
        return !this.foundValue;
    }

    public static List<String> parsePath(String path) {
        String[] pathList = path.split("/");
        ArrayList<String> pathSteps = new ArrayList<String>();
        for (String step : pathList) {
            if (step.length() <= 0) continue;
            pathSteps.add(step);
        }
        return pathSteps;
    }
}

