/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.stax;

import com.cognos.cm.util.stax.PathParser;
import com.cognos.cm.util.stax.StaxVariableExtractorPlugin;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class StaxSectionDelegate
extends StreamReaderDelegate {
    private static final String HREF = "href";
    private String[] pathToPlugin;
    private boolean active = true;
    private boolean inPlugin = false;
    private int currentPos = 0;
    private StaxVariableExtractorPlugin plugin;
    private boolean encounteredHREF;

    public StaxSectionDelegate(XMLStreamReader staxXmlReader, StaxVariableExtractorPlugin plugin, PathParser path) {
        super(staxXmlReader);
        this.plugin = plugin;
        this.pathToPlugin = path.getSteps();
    }

    @Override
    public int next() throws XMLStreamException {
        int event = super.next();
        if (this.active) {
            switch (event) {
                case 1: {
                    this.startElement();
                    break;
                }
                case 4: {
                    this.characters();
                    break;
                }
                case 2: {
                    this.endElement();
                }
            }
        }
        return event;
    }

    private void endElement() {
        String localName = this.getLocalName();
        if (this.inPlugin) {
            this.plugin.endElement(localName);
        }
        if (this.searchingFor(localName)) {
            this.active = false;
            this.plugin.deactivate();
        }
    }

    private void characters() {
        if (this.inPlugin) {
            this.plugin.text(this.getText());
        }
    }

    private void startElement() {
        if (this.includesHREF()) {
            this.encounteredHREF = true;
            this.active = false;
            if (this.inPlugin) {
                this.plugin.deactivate();
            }
            return;
        }
        this.handleElementStart();
    }

    private void handleElementStart() {
        String localName = this.getLocalName();
        if (this.inPlugin) {
            this.plugin.startElement(localName);
        } else if (this.searchingFor(localName)) {
            this.advanceIterator();
        }
    }

    private void advanceIterator() {
        if (this.currentPos + 1 == this.pathToPlugin.length) {
            this.inPlugin = true;
            this.plugin.activate();
        } else {
            ++this.currentPos;
        }
    }

    private boolean includesHREF() {
        int attributeCount = this.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = this.getAttributeLocalName(i);
            if (!attributeName.toLowerCase().equals(HREF)) continue;
            return true;
        }
        return false;
    }

    private boolean searchingFor(String localName) {
        return this.pathToPlugin[this.currentPos].equals(localName);
    }

    public StaxVariableExtractorPlugin getPlugin() {
        return this.plugin;
    }

    public boolean parseSuccessful() {
        return !this.encounteredHREF;
    }
}

