/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.stax;

import com.cognos.cm.util.stax.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StaxVariableExtractorPlugin {
    private List<String> pluginPath = new ArrayList<String>();
    private Map<String, Boolean> elementPresent = new HashMap<String, Boolean>();
    private Map<String, String> elementText = new HashMap<String, String>();
    private Path[] extractorPaths;
    private Path[] existancePaths;
    private boolean hasChildren = false;

    public StaxVariableExtractorPlugin(Path[] textExtractorPaths, Path[] existancePaths) {
        this.extractorPaths = textExtractorPaths;
        this.existancePaths = existancePaths;
    }

    public void startElement(String localName) {
        if (!this.hasChildren) {
            this.hasChildren = true;
        }
        this.pluginPath.add(localName);
        for (Path checker : this.existancePaths) {
            if (!this.pathIs(checker)) continue;
            this.elementPresent.put(checker.getVariable(), true);
        }
    }

    public void endElement(String localName) {
        this.pluginPath.remove(localName);
    }

    public void text(String text) {
        for (Path path : this.extractorPaths) {
            if (!this.pathIs(path)) continue;
            this.elementText.put(path.getVariable(), text);
        }
    }

    protected boolean pathIs(Path path) {
        return path.pathMatches(this.pluginPath);
    }

    public boolean elementPresent(String variableName) {
        return this.elementPresent.containsKey(variableName) && this.elementPresent.get(variableName) != false;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public String getTextValue(String variableName) {
        return this.elementText.get(variableName);
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }
}

