/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.jmx;

import com.cognos.cm.util.CMDateUtils;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class DiskSpaceCalculator
implements Runnable {
    private static final long RECALCULATION_INTERVAL_HOURS = 24L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    static final long RECALCULATION_INTERVAL_MILLIS = 86400000L;
    private final Log log = LogFactory.getLog(DiskSpaceCalculator.class);
    private final CMDateUtils.Clock clock;
    private volatile double value;
    private volatile long lastCalculated;
    private volatile boolean isRunning;

    DiskSpaceCalculator(CMDateUtils.Clock clock) {
        this.clock = clock;
        this.reset();
    }

    abstract double calculateValue();

    public void reset() {
        this.value = 0.0;
        this.lastCalculated = 0L;
    }

    public Date getLastCalculated() {
        return new Date(this.lastCalculated);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void run() {
        if (this.checkAndStartRunning()) {
            try {
                this.lastCalculated = this.clock.getTimeMillis();
                this.log.debug((Object)"Starting calculation...");
                this.value = this.convertBytesToGigabytes(this.calculateValue());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Calculation result: " + this.value));
                }
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    public boolean isTimeToExecute() {
        return this.clock.getTimeMillis() >= this.lastCalculated + 86400000L;
    }

    private synchronized boolean checkAndStartRunning() {
        boolean startCalculation;
        boolean bl = startCalculation = !this.isRunning && this.isTimeToExecute();
        if (startCalculation) {
            this.isRunning = true;
        }
        return startCalculation;
    }

    private double convertBytesToGigabytes(double bytes) {
        double gigabytes = bytes * 9.31323E-10;
        double precision = bytes >= 1.07374E8 ? 10.0 : (bytes >= 1.07374E7 ? 100.0 : (bytes >= 1073740.0 ? 1000.0 : (bytes >= 107374.0 ? 10000.0 : (bytes >= 10737.0 ? 100000.0 : 1000000.0))));
        return (double)Math.round(gigabytes * precision) / precision;
    }
}

