/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.jmx;

import com.cognos.cm.backgroundTask.BackgroundTasksManager;
import com.cognos.cm.externalRepository.ExternalObjectStoreConnectionProvider;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.service.CMRunningMode;
import com.cognos.cm.util.service.ServiceStateHelper;
import com.cognos.perfMonitor.jmx.DiskSpaceCalculator;
import com.cognos.perfMonitor.jmx.ExternalObjectStoreMetricsMBean;
import com.cognos.pogo.monitoring.CounterMbeanInterface;
import java.util.Date;
import java.util.concurrent.Executor;

public class ExternalObjectStoreMetrics
implements ExternalObjectStoreMetricsMBean,
CounterMbeanInterface {
    private static ExternalObjectStoreMetrics instance = new ExternalObjectStoreMetrics("externalObjectStore");
    private final ServiceStateHelper serviceStateHelper;
    private final Executor executor;
    private final String name;
    private final DiskSpaceCalculator usedSpaceCalculator;
    private final DiskSpaceCalculator freeSpaceCalculator;
    private Date lastExternalObjectStoreResetTime;

    ExternalObjectStoreMetrics(String name) {
        this(name, ExternalObjectStoreConnectionProvider.getInstance(), ServiceStateHelper.getInstance(), CMDateUtils.getClock(), BackgroundTasksManager.getManager().getExecutorService());
    }

    ExternalObjectStoreMetrics(String name, final ExternalObjectStoreConnectionProvider provider, ServiceStateHelper serviceStateHelper, CMDateUtils.Clock clock, Executor executor) {
        this.name = name;
        this.serviceStateHelper = serviceStateHelper;
        this.executor = executor;
        this.usedSpaceCalculator = new DiskSpaceCalculator(clock){

            @Override
            double calculateValue() {
                return provider.getUsedSpace();
            }
        };
        this.freeSpaceCalculator = new DiskSpaceCalculator(clock){

            @Override
            double calculateValue() {
                return provider.getFreeSpace();
            }
        };
        this.reset();
    }

    public static ExternalObjectStoreMetrics getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public double getFreeSpace() {
        return this.getOrCalculateMetric(this.freeSpaceCalculator);
    }

    @Override
    public double getUsedSpace() {
        return this.getOrCalculateMetric(this.usedSpaceCalculator);
    }

    private double getOrCalculateMetric(DiskSpaceCalculator calculator) {
        if (this.isCMRunning() && calculator.isTimeToExecute()) {
            this.executor.execute(calculator);
        }
        return calculator.getValue();
    }

    protected boolean isCMRunning() {
        return this.serviceStateHelper.getCMRunningMode().equals((Object)CMRunningMode.RUNNING);
    }

    @Override
    public void reset() {
        this.lastExternalObjectStoreResetTime = new Date();
        this.usedSpaceCalculator.reset();
        this.freeSpaceCalculator.reset();
    }

    @Override
    public Date getLastExternalObjectStoreResetTime() {
        return this.lastExternalObjectStoreResetTime;
    }

    @Override
    public Date getFreeSpaceLastUpdateTime() {
        return this.freeSpaceCalculator.getLastCalculated();
    }

    @Override
    public Date getUsedSpaceLastUpdateTime() {
        return this.usedSpaceCalculator.getLastCalculated();
    }
}

