/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.jmx;

import com.cognos.cm.backgroundTaskPluginAPI.CMQueueItemState;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueStatus;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueStatusInfo;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.queues.CMQueueManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.perfMonitor.jmx.ExternalizedDocumentMetricsMBean;
import com.cognos.perfMonitor.jmx.MBeanNotificationObject;
import com.cognos.perfMonitor.jmx.MBeanNotificationQueue;
import com.cognos.pogo.monitoring.CounterMbeanInterface;
import java.util.Date;
import java.util.List;

public class ExternalizedDocumentMetrics
implements ExternalizedDocumentMetricsMBean,
CounterMbeanInterface {
    private static final String NUMBEROFFAILEDEXTERNALIZEDDOCUMENTS = "NumberOfFailedExternalizedDocuments";
    private static final String SUCCESSFULEXTERNALIZEDDOCUMENTSPERCENT = "SuccessfulExternalizedDocumentsPercent";
    private static final String FAILEDEXTERNALIZEDDOCUMENTSPERCENT = "FailedExternalizedDocumentsPercent";
    private static final String NUMBEROFSUCCESSFULEXTERNALIZEDDOCUMENTS = "NumberOfSuccessfulExternalizedDocuments";
    private static final double ONE_HUNDRED_PERCENT = 1.0;
    private static final double ZERO_PERCENT = 0.0;
    private final Object updateToken = new Object();
    private long totalNumberOfFailed;
    private Date numberOfFailedExternalizedDocumentsLastUpdateTime = new Date();
    private long totalNumberOfSuccess;
    private Date numberOfSuccessfulExternalizedDocumentsLastUpdateTime = new Date();
    private double percentSuccess = 1.0;
    private Date successfulExternalizedDocumentsPercentLastUpdateTime = new Date();
    private double percentFailed = 0.0;
    private Date failedExternalizedDocumentsPercentLastUpdateTime = new Date();
    private Date lastExternalizedDocumentResetTime = new Date();
    private static ExternalizedDocumentMetrics sharedExternalizedDocumentMetricsInstance = new ExternalizedDocumentMetrics("externalizedDocument");
    private final String name;

    public ExternalizedDocumentMetrics(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public double getFailedExternalizedDocumentsPercent() {
        return this.percentFailed;
    }

    @Override
    public long getNumberOfFailedExternalizedDocuments() {
        return this.totalNumberOfFailed;
    }

    @Override
    public long getNumberOfSuccessfulExternalizedDocuments() {
        return this.totalNumberOfSuccess;
    }

    @Override
    public double getSuccessfulExternalizedDocumentsPercent() {
        return this.percentSuccess;
    }

    @Override
    public long getQueuedPendingExternalizedDocuments() {
        return this.getQueuedExternalizedDocuments(CMQueueItemState.AVAILABLE);
    }

    @Override
    public long getQueuedFailedExternalizedDocuments() {
        return this.getQueuedExternalizedDocuments(CMQueueItemState.FAILED);
    }

    private long getQueuedExternalizedDocuments(CMQueueItemState state) {
        ICMQueueManager manager = this.getCMQueueManager();
        long count = 0L;
        CMStore store = null;
        try {
            store = this.getCMStore();
            ICMQueueStatus status = manager.getStatus(store, "archiveQueue");
            List<ICMQueueStatusInfo> statusList = status.getStatus(store);
            for (ICMQueueStatusInfo icmQueueStatusInfo : statusList) {
                if (!icmQueueStatusInfo.getState().equals((Object)state)) continue;
                count = icmQueueStatusInfo.getCount();
            }
        }
        catch (CMException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (store != null) {
                store.release();
            }
        }
        return count;
    }

    ICMQueueManager getCMQueueManager() {
        return CMQueueManager.getManager();
    }

    CMStore getCMStore() {
        return CMDbStoreFactory.getStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.updateToken;
        synchronized (object) {
            this.updateNumberOfSuccesses(0L);
            this.updateNumberOfFailures(0L);
            this.updatePercentSuccess(1.0);
            this.updatePercentFailure(0.0);
            this.lastExternalizedDocumentResetTime.setTime(this.getCurrentMilliseconds());
        }
    }

    @Override
    public Date getFailedExternalizedDocumentsPercentLastUpdateTime() {
        return this.failedExternalizedDocumentsPercentLastUpdateTime;
    }

    @Override
    public Date getNumberOfFailedExternalizedDocumentsLastUpdateTime() {
        return this.numberOfFailedExternalizedDocumentsLastUpdateTime;
    }

    @Override
    public Date getNumberOfSuccessfulExternalizedDocumentsLastUpdateTime() {
        return this.numberOfSuccessfulExternalizedDocumentsLastUpdateTime;
    }

    @Override
    public Date getSuccessfulExternalizedDocumentsPercentLastUpdateTime() {
        return this.successfulExternalizedDocumentsPercentLastUpdateTime;
    }

    @Override
    public Date getLastExternalizedDocumentResetTime() {
        return this.lastExternalizedDocumentResetTime;
    }

    public static ExternalizedDocumentMetrics getSharedInstance() {
        return sharedExternalizedDocumentMetricsInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSuccess() {
        Object object = this.updateToken;
        synchronized (object) {
            this.updateNumberOfSuccesses(this.totalNumberOfSuccess + 1L);
            this.updatePercents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportFailure() {
        Object object = this.updateToken;
        synchronized (object) {
            this.updateNumberOfFailures(this.totalNumberOfFailed + 1L);
            this.updatePercents();
        }
    }

    private synchronized void updatePercents() {
        long totalAttempts = this.totalNumberOfFailed + this.totalNumberOfSuccess;
        if (totalAttempts > 0L) {
            double successRate = (double)this.totalNumberOfSuccess / (double)totalAttempts;
            double failureRate = (double)this.totalNumberOfFailed / (double)totalAttempts;
            this.updatePercentSuccess(successRate);
            this.updatePercentFailure(failureRate);
        }
    }

    private void updateNumberOfSuccesses(long newValue) {
        long oldValue = this.totalNumberOfSuccess;
        this.totalNumberOfSuccess = newValue;
        this.numberOfSuccessfulExternalizedDocumentsLastUpdateTime.setTime(this.getCurrentMilliseconds());
        this.sendChangeNotification(NUMBEROFSUCCESSFULEXTERNALIZEDDOCUMENTS, oldValue, this.totalNumberOfSuccess);
    }

    private void updateNumberOfFailures(long newValue) {
        long oldValue = this.totalNumberOfFailed;
        this.totalNumberOfFailed = newValue;
        this.numberOfFailedExternalizedDocumentsLastUpdateTime.setTime(this.getCurrentMilliseconds());
        this.sendChangeNotification(NUMBEROFFAILEDEXTERNALIZEDDOCUMENTS, oldValue, this.totalNumberOfFailed);
    }

    private void updatePercentSuccess(double newValue) {
        double oldValue = this.percentSuccess;
        this.percentSuccess = newValue;
        this.successfulExternalizedDocumentsPercentLastUpdateTime.setTime(this.getCurrentMilliseconds());
        this.sendChangeNotification(SUCCESSFULEXTERNALIZEDDOCUMENTSPERCENT, oldValue, this.percentSuccess);
    }

    private void updatePercentFailure(double newValue) {
        double oldValue = this.percentFailed;
        this.percentFailed = newValue;
        this.failedExternalizedDocumentsPercentLastUpdateTime.setTime(this.getCurrentMilliseconds());
        this.sendChangeNotification(FAILEDEXTERNALIZEDDOCUMENTSPERCENT, oldValue, this.percentFailed);
    }

    protected long getCurrentMilliseconds() {
        return System.currentTimeMillis();
    }

    private void sendChangeNotification(String metric, long oldValue, long newValue) {
        MBeanNotificationObject obj = new MBeanNotificationObject(metric, oldValue, newValue);
        this.getMBeanNotificationQueue().add(obj);
    }

    private void sendChangeNotification(String metric, double oldValue, double newValue) {
        MBeanNotificationObject obj = new MBeanNotificationObject(metric, oldValue, newValue);
        this.getMBeanNotificationQueue().add(obj);
    }

    protected MBeanNotificationQueue getMBeanNotificationQueue() {
        return MBeanNotificationQueue.getMBeanNotificationQueue();
    }
}

