/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.jmx;

import com.cognos.perfMonitor.jmx.MBeanNotificationObject;
import com.cognos.pogo.monitoring.jmx.MetricNotificationSupport;
import java.util.concurrent.LinkedBlockingQueue;
import javax.management.AttributeChangeNotification;

public class MBeanNotificationQueue
extends MetricNotificationSupport {
    private static MBeanNotificationQueue theQueue = new MBeanNotificationQueue();
    private LinkedBlockingQueue<MBeanNotificationObject> queue = new LinkedBlockingQueue();
    private MBeanNotificationThread thread = new MBeanNotificationThread();

    private MBeanNotificationQueue() {
        this.thread.start();
    }

    public static MBeanNotificationQueue getMBeanNotificationQueue() {
        return theQueue;
    }

    public void add(MBeanNotificationObject o) {
        try {
            this.queue.put(o);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void send() {
        try {
            MBeanNotificationObject o = this.queue.take();
            AttributeChangeNotification attributeChangeNotification = this.createNotification(o.getMetric(), o.getOldValue(), o.getNewValue());
            this.sendNotification(attributeChangeNotification);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private class MBeanNotificationThread
    extends Thread {
        private volatile boolean bRun = true;

        @Override
        public void run() {
            while (this.bRun) {
                MBeanNotificationQueue.this.send();
            }
        }

        public void terminate() {
            this.bRun = false;
            this.interrupt();
        }
    }
}

