/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.jmx;

import com.cognos.cm.server.UserSessionCache;
import com.cognos.cm.util.ArchivingUtil;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfNotification;
import com.cognos.perfMonitor.jmx.ExternalObjectStoreMetrics;
import com.cognos.perfMonitor.jmx.ExternalizedDocumentMetrics;
import com.cognos.perfMonitor.jmx.SessionMetrics;
import com.cognos.pogo.monitoring.CounterMbeanInterface;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;

public class MBeanRegister {
    private static String serviceName = "contentManagerService";
    protected static ArchivingUtil archiveUtil;
    protected static MBeanServer pogoServer;
    protected static MBeanServer server;

    public static void registerMBeans() {
        MBeanRegister.registerSessionMetricsMBean();
        if (MBeanRegister.isRepositoryIntegrationInstalled()) {
            MBeanRegister.registerExternalizedDocumentMetricsMBean();
        }
        MBeanRegister.registerExternalObjectStoreMBean();
    }

    private static void registerExternalObjectStoreMBean() {
        ExternalObjectStoreMetrics eosMetrics = ExternalObjectStoreMetrics.getInstance();
        MBeanRegister.registerBean(eosMetrics.getName(), eosMetrics);
    }

    protected static boolean isRepositoryIntegrationInstalled() {
        if (archiveUtil == null) {
            archiveUtil = new ArchivingUtil();
        }
        return archiveUtil.isArchivingSoftwareInstalled();
    }

    protected static MBeanServer getServer() {
        return server;
    }

    protected static void setServer(MBeanServer newRegistrar) {
        server = newRegistrar;
    }

    private static void registerSessionMetricsMBean() {
        SessionMetrics sessionMetrics = new SessionMetrics("session");
        PerfCounter sessionsTotal = UserSessionCache.PERF_COUNTER_SESSIONS_TOTAL;
        sessionsTotal.setNotificationObject((PerfNotification)sessionMetrics);
        MBeanRegister.registerBean(sessionMetrics.getName(), sessionMetrics);
    }

    private static void registerExternalizedDocumentMetricsMBean() {
        ExternalizedDocumentMetrics externalizedDocumentMetrics = ExternalizedDocumentMetrics.getSharedInstance();
        MBeanRegister.registerBean(externalizedDocumentMetrics.getName(), externalizedDocumentMetrics);
    }

    private static void registerBean(String name, Object mbean) {
        MBeanRegister.getServer().registerMBean(serviceName, name, mbean);
    }

    static {
        server = pogoServer = new MBeanServer(){

            @Override
            public void registerMBean(String service, String mbeanName, Object mbean) {
                PogoMBeanServer server = PogoMBeanServer.getInstance();
                CounterMbeanInterface pogoMbean = (CounterMbeanInterface)mbean;
                server.registerMBean(pogoMbean, serviceName);
            }
        };
    }

    protected static interface MBeanServer {
        public void registerMBean(String var1, String var2, Object var3);
    }
}

