/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.perfMonitor.jmx;

import com.cognos.cm.server.UserSessionCache;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfCounterTypeEnum;
import com.cognos.perfMonitor.PerfNotification;
import com.cognos.perfMonitor.jmx.MBeanNotificationObject;
import com.cognos.perfMonitor.jmx.MBeanNotificationQueue;
import com.cognos.perfMonitor.jmx.SessionMetricsMBean;
import com.cognos.pogo.monitoring.CounterMbeanInterface;
import java.util.Date;

public class SessionMetrics
implements SessionMetricsMBean,
CounterMbeanInterface,
PerfNotification {
    private static final PerfCounter SESSIONS_TOTAL = UserSessionCache.PERF_COUNTER_SESSIONS_TOTAL;
    private final String name;
    private Date lastResetTime = new Date(0L);

    public SessionMetrics(String sName) {
        this.name = sName;
        this.setLastResetTime();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void reset() {
        SESSIONS_TOTAL.resetPeriod();
        this.setLastResetTime();
    }

    @Override
    public Date getLastSessionResetTime() {
        return this.lastResetTime;
    }

    @Override
    public long getNumberOfSessions() {
        return SESSIONS_TOTAL.getTotalCount();
    }

    @Override
    public Date getNumberOfSessionsLastUpdateTime() {
        long time = SESSIONS_TOTAL.getTotalCountLastUpdateTime();
        return this.getLastUpdateTime(time);
    }

    @Override
    public long getNumberOfSessionsHighWaterMark() {
        return SESSIONS_TOTAL.getThisPeriodHighWatermark();
    }

    @Override
    public Date getNumberOfSessionsHighWaterMarkLastUpdateTime() {
        long time = SESSIONS_TOTAL.getThisPeriodHighWatermarkLastUpdateTime();
        return this.getLastUpdateTime(time);
    }

    @Override
    public long getNumberOfSessionsLowWaterMark() {
        return SESSIONS_TOTAL.getThisPeriodLowWatermark();
    }

    @Override
    public Date getNumberOfSessionsLowWaterMarkLastUpdateTime() {
        long time = SESSIONS_TOTAL.getThisPeriodLowWatermarkLastUpdateTime();
        return this.getLastUpdateTime(time);
    }

    public void sendThisPeriodValueChangeNotification(PerfCounterTypeEnum counter, long oldValue, long newValue) {
        if (counter == PerfCounterTypeEnum.CTR_HIGH_WATERMARK) {
            MBeanNotificationObject obj = new MBeanNotificationObject("NumberOfSessionsHighWaterMark", oldValue, newValue);
            MBeanNotificationQueue.getMBeanNotificationQueue().add(obj);
        } else if (counter == PerfCounterTypeEnum.CTR_LOW_WATERMARK) {
            MBeanNotificationObject obj = new MBeanNotificationObject("NumberOfSessionsLowWaterMark", oldValue, newValue);
            MBeanNotificationQueue.getMBeanNotificationQueue().add(obj);
        }
    }

    public void sendTotalValueChangeNotification(PerfCounterTypeEnum counter, long oldValue, long newValue) {
        if (counter == PerfCounterTypeEnum.CTR_COUNT) {
            MBeanNotificationObject obj = new MBeanNotificationObject("NumberOfSessions", oldValue, newValue);
            MBeanNotificationQueue.getMBeanNotificationQueue().add(obj);
        }
    }

    private void setLastResetTime() {
        this.lastResetTime.setTime(System.currentTimeMillis());
    }

    private Date getLastUpdateTime(long lastUpdateTime) {
        Date numberOfSessionsLowWaterMarkLastUpdateTime = new Date();
        numberOfSessionsLowWaterMarkLastUpdateTime.setTime(lastUpdateTime);
        return numberOfSessionsLowWaterMarkLastUpdateTime;
    }
}

