/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.CMISRepository;

import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.CMISRepository.RepositoryPluginHttpClient;
import com.ibm.cognos.cm.ecm.cm8.CM8RepositoryConnection;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomConnection;
import com.ibm.cognos.cm.ecm.connection.CMISRepositoryConnection;
import com.ibm.cognos.cm.ecm.filenet.FileNetRepositoryConnection;
import com.ibm.cognos.cm.ecm.util.CMISRepositoryErrors;
import java.util.Properties;

public class CMISRepositoryConnectionFactory {
    private static final CMISRepositoryConnectionFactory INSTANCE = new CMISRepositoryConnectionFactory();
    public static final String PROVIDER = "PROVIDER";
    public static final String CM8_PROVIDER = "CM8";
    public static final String FILENET_PROVIDER = "FILENET";

    RepositoryConnection create(String url, Properties properties, IRepositoryConnectionConfiguration configuration, RepositoryPluginHttpClient httpClient) throws RepositoryException {
        CMISRepositoryConnection connection = null;
        String provider = properties.getProperty(PROVIDER);
        this.configureClient(url, properties, httpClient);
        if (CM8_PROVIDER.equalsIgnoreCase(provider)) {
            AtomConnection cmisConnection = new AtomConnection(httpClient);
            connection = new CM8RepositoryConnection(url, cmisConnection, configuration, properties);
        } else if (FILENET_PROVIDER.equalsIgnoreCase(provider)) {
            AtomConnection cmisConnection = new AtomConnection(httpClient);
            connection = new FileNetRepositoryConnection(url, cmisConnection, configuration, properties);
        } else {
            throw new RepositoryException((Resource.Id)CMISRepositoryErrors.CRP_OPF.failedToGetConnection);
        }
        return connection;
    }

    private void configureClient(String url, Properties properties, RepositoryPluginHttpClient httpClient) {
        httpClient.setCredentials(properties.getProperty("user"), properties.getProperty("password"));
        httpClient.setBaseURI(url);
    }

    static CMISRepositoryConnectionFactory getInstance() {
        return INSTANCE;
    }
}

