/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.CMISRepository;

import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.cognos.cm.repositoryPluginAPI.IRepositoryHttpClientFactory;
import com.cognos.cm.repositoryPluginAPI.IRepositoryPluginContainer;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnectionProperties;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginAPI.RepositoryPlugin;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.CMISRepository.CMISRepositoryConnectionFactory;
import com.ibm.cognos.cm.CMISRepository.RepositoryPluginHttpClient;
import com.ibm.cognos.cm.ecm.util.CMISRepositoryErrors;
import com.ibm.cognos.cm.repositoryplugincommon.httpclient.CAMHttpClientProvider;
import com.ibm.cognos.cm.repositoryplugincommon.httpclient.HttpClientProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.dom4j.Document;

public class CMISRepositoryPlugin
implements RepositoryPlugin {
    private final HttpClientProvider httpClientProvider;
    private final CMISRepositoryConnectionFactory repositoryConnectionFactory;

    public CMISRepositoryPlugin() {
        this((HttpClientProvider)CAMHttpClientProvider.getInstance(), CMISRepositoryConnectionFactory.getInstance());
    }

    CMISRepositoryPlugin(HttpClientProvider httpClientProvider) {
        this(httpClientProvider, CMISRepositoryConnectionFactory.getInstance());
    }

    CMISRepositoryPlugin(HttpClientProvider httpClientProvider, CMISRepositoryConnectionFactory repositoryConnectionFactory) {
        this.httpClientProvider = httpClientProvider;
        this.repositoryConnectionFactory = repositoryConnectionFactory;
    }

    public RepositoryConnection getConnection(String url, IRepositoryPluginContainer pluginContainer, Properties properties) throws RepositoryException {
        if (!properties.containsKey("PROVIDER")) {
            properties.put("PROVIDER", "FILENET");
        }
        IRepositoryConnectionConfiguration configuration = pluginContainer.getConnectionConfiguration();
        RepositoryPluginHttpClient httpClient = this.getRepositoryHttpClient(url);
        RepositoryConnection connection = this.repositoryConnectionFactory.create(url, properties, configuration, httpClient);
        this.testConnection(properties, connection);
        return connection;
    }

    public RepositoryConnection getConnection(IRepositoryUserAgentFactory repositoryUserAgentFactory, String url, IRepositoryPluginContainer pluginContainer, Properties properties) throws RepositoryException {
        if (!properties.containsKey("PROVIDER")) {
            properties.put("PROVIDER", "FILENET");
        }
        IRepositoryConnectionConfiguration configuration = pluginContainer.getConnectionConfiguration();
        RepositoryPluginHttpClient httpClient = this.getRepositoryHttpClient(repositoryUserAgentFactory, url);
        RepositoryConnection connection = this.repositoryConnectionFactory.create(url, properties, configuration, httpClient);
        this.testConnection(properties, connection);
        return connection;
    }

    private void testConnection(Properties properties, RepositoryConnection connection) throws RepositoryException {
        String testRequired = (String)properties.get(RepositoryConnectionProperties.TEST_REPOSITORY_CONNECTION);
        if (testRequired != null && testRequired.equalsIgnoreCase("true")) {
            connection.test();
        }
    }

    private RepositoryPluginHttpClient getRepositoryHttpClient(String urlString) throws RepositoryException {
        URL url = this.getURL(urlString);
        HttpClient httpClient = this.httpClientProvider.create(url);
        return new RepositoryPluginHttpClient(httpClient);
    }

    private RepositoryPluginHttpClient getRepositoryHttpClient(IRepositoryUserAgentFactory repositoryUserAgentFactory, String urlString) throws RepositoryException {
        if (!(repositoryUserAgentFactory instanceof IRepositoryHttpClientFactory)) {
            throw new IllegalStateException("repositoryUserAgentFactory must be of type IRepositoryHttpClientFactory!");
        }
        IRepositoryHttpClientFactory repositoryHttpClientFactory = (IRepositoryHttpClientFactory)repositoryUserAgentFactory;
        URL url = this.getURL(urlString);
        boolean secure = url.getProtocol() != null && url.getProtocol().startsWith("https");
        return new RepositoryPluginHttpClient(repositoryHttpClientFactory.createHttpClient(url.getHost(), url.getPort(), secure));
    }

    private URL getURL(String urlString) throws RepositoryException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            Message msg = new Message((Resource.Id)CMISRepositoryErrors.CRP_REQ.invalidConnectionString).param("connectionString", urlString);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return url;
    }

    public void initialize(Document configurationDocument) throws RepositoryException {
    }

    public void terminate() {
    }
}

