/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.CMISRepository;

import com.cognos.cm.repositoryPluginAPI.HttpClientHelper;
import com.cognos.cm.repositoryPluginAPI.IRepositoryTimer;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnectionException;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.CMISRepository.RepositoryPluginHttpResponseResult;
import com.ibm.cognos.cm.ecm.cmis.CMISException;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpClient;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpResult;
import com.ibm.cognos.cm.ecm.cmis.ObjectNotFoundException;
import com.ibm.cognos.cm.ecm.util.CMISRepositoryErrors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Base64;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryPluginHttpClient
implements CMISHttpClient {
    private static String baseLogCategory = RepositoryPluginHttpClient.class.getName();
    private static final Log log = LogFactory.getLog((String)baseLogCategory);
    private static final Log logHttpReq = LogFactory.getLog((String)(baseLogCategory + ".http.request"));
    private static final Log logHttpReqHeaders = LogFactory.getLog((String)(baseLogCategory + ".http.request.headers"));
    private static final Log logHttpRsp = LogFactory.getLog((String)(baseLogCategory + ".http.response"));
    private static final Log logHttpRspHeaders = LogFactory.getLog((String)(baseLogCategory + ".http.response.headers"));
    private HttpClient client;
    public static final String REQUEST_HEADER_AUTHORIZATION = "Authorization";
    public static final String REQUEST_HEADER_CONTENTTYPE = "Content-Type";
    public static final String REQUEST_HEADER_CHECKIN = "checkin";
    public static final String REQUEST_HEADER_MAJOR = "major";
    public static final String REQUEST_HEADER_BASIC = "Basic ";
    public static final String REQUEST_HEADER_RANGE = "Range";
    private long millis;
    private IRepositoryTimer timer;
    private String encodedCredentials;
    private String userName;
    private String baseURI;

    public RepositoryPluginHttpClient(HttpClient httpClient) {
        this.client = httpClient;
    }

    @Override
    public CMISHttpResult postResource(String uri, String resourceDocument, String mimetype) {
        try {
            URI postURI = this.getURI(uri);
            EntityEnclosingMethod method = this.createPostMethod(postURI, this.encodedCredentials, resourceDocument, mimetype);
            RepositoryPluginHttpResponseResult result = this.executeMethod((HttpMethod)method);
            this.verifyResponse(result, CMISRepositoryErrors.CRP_OPF.failedToAddArchive);
            return result;
        }
        catch (CMISException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.generateCMISException(e);
        }
    }

    @Override
    public CMISHttpResult putResource(String contentStreamURI, String contentType, String content) {
        return this.putResourceAsStream(contentStreamURI, contentType, new ByteArrayInputStream(content.getBytes(Charsets.UTF_8)));
    }

    @Override
    public CMISHttpResult putResourceAsStream(String contentStreamURI, String contentType, InputStream stream) {
        try {
            URI uri = this.getURI(contentStreamURI);
            PutMethod method = this.createPutMethod();
            this.setupForContentStream(method, uri, contentType, stream);
            RepositoryPluginHttpResponseResult result = this.executeMethod((HttpMethod)method);
            this.verifyResponse(result, CMISRepositoryErrors.CRP_OPF.failedToAddArchive);
            return result;
        }
        catch (CMISException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.generateCMISException(e);
        }
    }

    @Override
    public CMISHttpResult checkinAtomEntry(String checkinURI, String entry) {
        try {
            URI uri = this.getURI(checkinURI);
            PutMethod method = this.createPutMethod();
            this.setupForCheckin(method, uri, entry);
            RepositoryPluginHttpResponseResult result = this.executeMethod((HttpMethod)method);
            this.verifyResponse(result, CMISRepositoryErrors.CRP_OPF.failedToAddArchive);
            return result;
        }
        catch (CMISException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.generateCMISException(e);
        }
    }

    @Override
    public CMISHttpResult getResource(String resourceURI) {
        try {
            URI uri = this.getURI(resourceURI);
            GetMethod method = this.createGetMethod();
            CMISHttpResult result = this.executeResourceMethod(uri, (HttpMethod)method);
            this.verifyResponse(result, CMISRepositoryErrors.CRP_OPF.failedToGetArchive);
            return result;
        }
        catch (CMISException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.generateCMISException(e);
        }
    }

    @Override
    public CMISHttpResult deleteResource(String resourceURI) {
        try {
            URI uri = this.getURI(resourceURI);
            DeleteMethod method = this.createDeleteMethod();
            CMISHttpResult result = this.executeResourceMethod(uri, (HttpMethod)method);
            this.verifyResponse(result, CMISRepositoryErrors.CRP_OPF.failedToDeleteContent);
            return result;
        }
        catch (CMISException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.generateCMISException(e);
        }
    }

    @Override
    public void setCredentials(String userName, String password) {
        String credentials = userName + ":" + password;
        this.encodedCredentials = new String(Base64.getEncoder().encode(credentials.getBytes(Charsets.UTF_8)));
        this.userName = userName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    private void verifyResponse(CMISHttpResult result, Resource.Id failureMessage) throws IOException {
        switch (result.getStatusCode()) {
            case 200: 
            case 201: 
            case 204: {
                return;
            }
            case 404: {
                Message msg = new Message((Resource.Id)CMISRepositoryErrors.CRP_OPF.failedToGetArchive);
                msg.addDetail(new String(IOUtils.toByteArray((InputStream)result.getResponseStream()), Charsets.UTF_8));
                throw new ObjectNotFoundException(msg);
            }
        }
        Message msg = new Message(failureMessage);
        msg.addDetail(new String(IOUtils.toByteArray((InputStream)result.getResponseStream()), Charsets.UTF_8));
        throw new CMISException(msg);
    }

    private CMISException generateCMISException(Exception e) {
        Message failure = new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.failedToPerformHttpRequest);
        failure.addDetail(e.getMessage());
        return new CMISException(failure, e);
    }

    private void setupForContentStream(PutMethod method, URI uri, String contentType, InputStream stream) throws URIException {
        InputStreamRequestEntity ire = new InputStreamRequestEntity(stream, -2L);
        method.setRequestEntity((RequestEntity)ire);
        method.addRequestHeader(REQUEST_HEADER_CONTENTTYPE, contentType);
        HttpClientHelper.setMethodPath((HttpClient)this.client, (HttpMethod)method, (URI)uri);
        if (this.encodedCredentials != null) {
            method.setRequestHeader(REQUEST_HEADER_AUTHORIZATION, REQUEST_HEADER_BASIC + this.encodedCredentials);
        }
    }

    private void setupForCheckin(PutMethod method, URI uri, String entry) throws URIException, UnsupportedEncodingException {
        StringRequestEntity ire = new StringRequestEntity(entry, null, Charsets.UTF_8.name());
        method.setRequestEntity((RequestEntity)ire);
        method.addRequestHeader(REQUEST_HEADER_CONTENTTYPE, "application/atom+xml;type=entry");
        method.addRequestHeader(REQUEST_HEADER_MAJOR, Boolean.TRUE.toString());
        method.addRequestHeader(REQUEST_HEADER_CHECKIN, Boolean.TRUE.toString());
        HttpClientHelper.setMethodPath((HttpClient)this.client, (HttpMethod)method, (URI)uri);
        if (this.encodedCredentials != null) {
            method.setRequestHeader(REQUEST_HEADER_AUTHORIZATION, REQUEST_HEADER_BASIC + this.encodedCredentials);
        }
    }

    private void setupForResourceAction(HttpMethod method, URI uri) throws URIException {
        HttpClientHelper.setMethodPath((HttpClient)this.client, (HttpMethod)method, (URI)uri);
        if (this.encodedCredentials != null) {
            method.setRequestHeader(REQUEST_HEADER_AUTHORIZATION, REQUEST_HEADER_BASIC + this.encodedCredentials);
        }
    }

    private CMISHttpResult executeResourceMethod(URI uri, HttpMethod method) throws RepositoryException, IOException {
        this.setupForResourceAction(method, uri);
        return this.executeMethod(method);
    }

    @Deprecated
    public RepositoryPluginHttpResponseResult executePostAtomEntryMethod(URI uri, String encodedUserCredentials, String et) throws RepositoryException, IOException {
        uri = this.getRelativeURI(uri);
        EntityEnclosingMethod method = this.createPostMethod(uri, encodedUserCredentials, et, "application/atom+xml;type=entry");
        return this.executeMethod((HttpMethod)method);
    }

    @Deprecated
    public RepositoryPluginHttpResponseResult executePostQueryMethod(URI uri, String encodedUserCredentials, String et) throws RepositoryException, IOException {
        uri = this.getRelativeURI(uri);
        EntityEnclosingMethod method = this.createPostMethod(uri, encodedUserCredentials, et, "application/cmisquery+xml");
        return this.executeMethod((HttpMethod)method);
    }

    @Deprecated
    private URI getRelativeURI(URI uri) throws URIException {
        uri = new URI(uri.getPath(), false);
        return uri;
    }

    @Deprecated
    public RepositoryPluginHttpResponseResult executeDeleteMethod(URI uri, String encodedUserCred) throws RepositoryException, IOException {
        uri = this.getRelativeURI(uri);
        HttpMethod method = this.createSetupDeleteMethod(uri, encodedUserCred);
        return this.executeMethod(method);
    }

    @Deprecated
    public RepositoryPluginHttpResponseResult executeGetMethod(URI uri, String encodedUserCred) throws RepositoryException, IOException {
        uri = this.getRelativeURI(uri);
        HttpMethod method = this.createSetupGetMethod(uri, encodedUserCred);
        return this.executeMethod(method);
    }

    @Deprecated
    public RepositoryPluginHttpResponseResult executeGetRangeMethod(URI uri, String encodedUserCred, String range) throws RepositoryException, IOException {
        uri = this.getRelativeURI(uri);
        HttpMethod method = this.createSetupGetMethod(uri, encodedUserCred);
        method.setRequestHeader(REQUEST_HEADER_RANGE, range);
        return this.executeMethod(method);
    }

    @Deprecated
    public RepositoryPluginHttpResponseResult executePutMethod(URI uri, String encodedUserCredentials, String contentType, Object request, boolean checkin) throws RepositoryException, IOException {
        return this.executePutMethod(uri, encodedUserCredentials, contentType, request, -1L, checkin);
    }

    @Deprecated
    public RepositoryPluginHttpResponseResult executePutMethod(String path, String contentType, Object request, boolean checkin) throws RepositoryException, IOException {
        URI uri = this.getURI(path);
        EntityEnclosingMethod method = this.createSetupPutMethod(uri, this.encodedCredentials, contentType, request, -1L, checkin);
        return this.executeMethod((HttpMethod)method);
    }

    @Deprecated
    public RepositoryPluginHttpResponseResult executePutMethod(URI uri, String encodedUserCredentials, String contentType, Object request, long dataLength, boolean checkin) throws RepositoryException, IOException {
        uri = this.getRelativeURI(uri);
        EntityEnclosingMethod method = this.createSetupPutMethod(uri, encodedUserCredentials, contentType, request, dataLength, checkin);
        return this.executeMethod((HttpMethod)method);
    }

    private URI getURI(String uri) throws URIException {
        URI builtURI = new URI(uri, false);
        builtURI = new URI(builtURI.getPath(), false);
        return builtURI;
    }

    private RepositoryPluginHttpResponseResult executeMethod(HttpMethod httpMethod) throws RepositoryException, IOException {
        this.logHTTPRequest(httpMethod);
        this.startTimer();
        try {
            this.client.executeMethod(httpMethod);
        }
        catch (ConnectException e) {
            this.handleConnectionException(e);
        }
        catch (UnknownHostException e) {
            this.handleUnknownHostException(httpMethod, e);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.logHTTPResponse(httpMethod);
            throw new RepositoryException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.failedToPerformHttpRequest).param("RootCause", e.getLocalizedMessage()), (Throwable)e);
        }
        finally {
            this.stopTimer();
            this.clearHTTPState();
        }
        this.logResponseTime(httpMethod);
        this.logHTTPResponse(httpMethod);
        if (httpMethod.getStatusCode() == 401) {
            throw new RepositoryException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.repositoryUnauthorized));
        }
        return new RepositoryPluginHttpResponseResult(httpMethod);
    }

    private void handleUnknownHostException(HttpMethod httpMethod, UnknownHostException e) throws IOException, RepositoryConnectionException {
        log.error((Object)e);
        this.logHTTPResponse(httpMethod);
        throw new RepositoryConnectionException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.repositoryUnknownHost).param("host", this.client.getHostConfiguration().getHost()));
    }

    private void handleConnectionException(ConnectException e) throws RepositoryConnectionException {
        log.error((Object)e);
        Message msg = new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.repositoryConnectionFailed);
        msg.param("host", this.client.getHostConfiguration().getHost());
        msg.param("port", String.valueOf(this.client.getHostConfiguration().getPort()));
        throw new RepositoryConnectionException(msg);
    }

    private void clearHTTPState() {
        HttpState state = this.client.getState();
        if (state != null) {
            state.clear();
        }
    }

    private void logResponseTime(HttpMethod httpMethod) {
        if (log.isDebugEnabled()) {
            String host = this.client.getHostConfiguration().toString();
            log.debug((Object)(host + " " + httpMethod.getName() + " " + httpMethod.getPath() + " result: " + httpMethod.getStatusCode() + " took: " + this.millis + " (ms)"));
        }
    }

    private boolean isPostOrPutMethod(HttpMethod httpMethod) {
        return httpMethod instanceof EntityEnclosingMethod;
    }

    private EntityEnclosingMethod createPostMethod(URI uri, String encodedUserCredentials, String et, String mimetype) throws URIException, UnsupportedEncodingException {
        PostMethod method = this.createPostMethod();
        this.postSetup(uri, encodedUserCredentials, et, (EntityEnclosingMethod)method, mimetype);
        return method;
    }

    protected PostMethod createPostMethod() {
        return new PostMethod();
    }

    protected void postSetup(URI uri, String encodedUserCredentials, String et, EntityEnclosingMethod method, String mimetype) throws UnsupportedEncodingException, URIException {
        StringRequestEntity sre = new StringRequestEntity(et, null, Charsets.UTF_8.name());
        ((PostMethod)method).setRequestEntity((RequestEntity)sre);
        HttpClientHelper.setMethodPath((HttpClient)this.client, (HttpMethod)method, (URI)uri);
        method.setRequestHeader(REQUEST_HEADER_CONTENTTYPE, mimetype);
        if (encodedUserCredentials != null) {
            method.setRequestHeader(REQUEST_HEADER_AUTHORIZATION, REQUEST_HEADER_BASIC + encodedUserCredentials);
        }
    }

    private EntityEnclosingMethod createSetupPutMethod(URI uri, String encodedUserCredentials, String contentType, Object request, long dataLength, boolean checkin) throws URIException, UnsupportedEncodingException {
        PutMethod method = this.createPutMethod();
        this.putSetup(method, uri, encodedUserCredentials, contentType, request, dataLength, checkin);
        return method;
    }

    protected PutMethod createPutMethod() {
        return new PutMethod();
    }

    protected void putSetup(PutMethod method, URI uri, String encodedUserCredentials, String contentType, Object request, long dataLength, boolean checkin) throws UnsupportedEncodingException, URIException {
        if (checkin) {
            method.addRequestHeader(REQUEST_HEADER_CHECKIN, Boolean.TRUE.toString());
        }
        if (request instanceof String) {
            StringRequestEntity sre = new StringRequestEntity((String)request, null, Charsets.UTF_8.name());
            method.setRequestEntity((RequestEntity)sre);
        } else {
            if (dataLength < 0L) {
                dataLength = -2L;
            }
            InputStreamRequestEntity ire = new InputStreamRequestEntity((InputStream)request, dataLength);
            method.setRequestEntity((RequestEntity)ire);
        }
        method.addRequestHeader(REQUEST_HEADER_MAJOR, Boolean.TRUE.toString());
        method.addRequestHeader(REQUEST_HEADER_CONTENTTYPE, contentType);
        HttpClientHelper.setMethodPath((HttpClient)this.client, (HttpMethod)method, (URI)uri);
        method.setRequestHeader(REQUEST_HEADER_AUTHORIZATION, REQUEST_HEADER_BASIC + encodedUserCredentials);
    }

    private HttpMethod createSetupGetMethod(URI uri, String encodedUserCred) throws URIException {
        GetMethod method = this.createGetMethod();
        this.getSetup(uri, encodedUserCred, (HttpMethod)method);
        return method;
    }

    protected GetMethod createGetMethod() {
        return new GetMethod();
    }

    protected void getSetup(URI uri, String encodedUserCred, HttpMethod method) throws URIException {
        HttpClientHelper.setMethodPath((HttpClient)this.client, (HttpMethod)method, (URI)uri);
        method.setRequestHeader(REQUEST_HEADER_AUTHORIZATION, REQUEST_HEADER_BASIC + encodedUserCred);
    }

    private HttpMethod createSetupDeleteMethod(URI uri, String encodedUserCred) throws URIException {
        DeleteMethod method = this.createDeleteMethod();
        this.getSetup(uri, encodedUserCred, (HttpMethod)method);
        return method;
    }

    protected DeleteMethod createDeleteMethod() {
        return new DeleteMethod();
    }

    private void startTimer() {
        if (this.timer != null) {
            this.timer.start();
        }
        this.millis = System.currentTimeMillis();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.millis = System.currentTimeMillis() - this.millis;
    }

    public void setTimeCounter(IRepositoryTimer timer) {
        this.timer = timer;
    }

    private void logHTTPRequest(HttpMethod method) {
        if (this.isPostOrPutMethod(method)) {
            this.logHTTPRequestEntity((EntityEnclosingMethod)method);
        }
    }

    private void logHTTPRequestEntity(EntityEnclosingMethod method) {
        RequestEntity requestEntity;
        this.logHTTPRequestHeaders((HttpMethod)method);
        if (logHttpReq.isDebugEnabled() && (requestEntity = method.getRequestEntity()) instanceof StringRequestEntity) {
            logHttpReq.debug((Object)((StringRequestEntity)requestEntity).getContent());
        }
    }

    private void logHTTPRequestHeaders(HttpMethod method) {
        if (logHttpReqHeaders.isDebugEnabled()) {
            Header[] headers = method.getRequestHeaders();
            String headersString = this.getHttpHeadersAsString(headers);
            logHttpReqHeaders.debug((Object)("request headers: " + headersString));
        }
    }

    private void logHTTPResponse(HttpMethod method) throws IOException {
        if (!this.isPostOrPutMethod(method)) {
            return;
        }
        if (logHttpRspHeaders.isDebugEnabled()) {
            Header[] headers = method.getResponseHeaders();
            String headersString = this.getHttpHeadersAsString(headers);
            logHttpRspHeaders.debug((Object)("response headers: " + headersString));
        }
        if (logHttpRsp.isDebugEnabled()) {
            logHttpRsp.debug((Object)method.getResponseBodyAsString());
        }
    }

    private String getHttpHeadersAsString(Header[] headers) {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        sb.append(lineSeparator);
        String separator = "";
        for (Header header : headers) {
            sb.append(separator);
            sb.append(header.getName()).append(": ").append(header.getValue());
            separator = lineSeparator;
        }
        return sb.toString();
    }
}

