/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.CMISRepository;

import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.ecm.cmis.CMISException;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpResult;
import com.ibm.cognos.cm.ecm.util.CMISRepositoryErrors;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public class RepositoryPluginHttpResponseResult
implements CMISHttpResult {
    private HttpMethod method;

    RepositoryPluginHttpResponseResult(HttpMethod method) {
        this.method = method;
    }

    @Override
    public InputStream getResponseStream() {
        try {
            return this.method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new CMISException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.failedToPerformHttpRequest), e);
        }
    }

    @Override
    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    @Override
    public String getStatusLine() {
        return this.method.getStatusLine().toString();
    }

    @Override
    public void release() {
        this.method.releaseConnection();
    }

    @Override
    public Properties getResponseHeaders() {
        Header[] headers = this.method.getResponseHeaders();
        Properties headerProperties = new Properties();
        for (Header header : headers) {
            headerProperties.put(header.getName(), header.getValue());
        }
        return headerProperties;
    }

    @Deprecated
    public InputStream getResponseBodyAsStream() throws IOException {
        return this.method.getResponseBodyAsStream();
    }

    @Deprecated
    public String getResponseBodyAsString() throws IOException {
        return this.method.getResponseBodyAsString();
    }
}

