/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cm8;

import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.ibm.cognos.cm.ecm.cmis.CMISConnection;
import com.ibm.cognos.cm.ecm.cmis.CMISID;
import com.ibm.cognos.cm.ecm.cmis.query.QueryHandlerFactory;
import com.ibm.cognos.cm.ecm.connection.CMISRepositoryConnection;
import com.ibm.cognos.cm.ecm.meta.CMISArchiveItem;
import com.ibm.cognos.cm.ecm.meta.DataDescriptorProcessor;
import java.util.Properties;
import java.util.regex.Pattern;

public class CM8RepositoryConnection
extends CMISRepositoryConnection {
    private static final int ID_PREFIX_LENGHT = 3;
    private static final Pattern CM8_ID_PATTERN = Pattern.compile("^[$][df]![0-9]{4}_[A-Z0-9]{26}v[0-9]$");

    public CM8RepositoryConnection(String archiveBaseUri, CMISConnection connection, IRepositoryConnectionConfiguration connectionConfiguration, Properties properties) {
        super(archiveBaseUri, connection, connectionConfiguration, properties);
    }

    CM8RepositoryConnection(String archiveBaseUri, CMISConnection connection, QueryHandlerFactory queryHandlerFactory, DataDescriptorProcessor dataDescriptorProcessor, Properties properties) {
        super(archiveBaseUri, connection, queryHandlerFactory, dataDescriptorProcessor, properties);
    }

    @Override
    protected CMISID createFolder(StringBuilder path, CMISID currentFolderID, CMISArchiveItem cmisArchiveItem) {
        CMISID folderID = super.createFolder(path, currentFolderID, cmisArchiveItem);
        path.append('{').append(folderID.getValue().substring(3)).append('}');
        return folderID;
    }

    public boolean validate(String outputID) {
        return CM8_ID_PATTERN.matcher(outputID).matches();
    }
}

