/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.atom;

import com.ibm.cognos.cm.ecm.cmis.CMISConnection;
import com.ibm.cognos.cm.ecm.cmis.CMISDocument;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpClient;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpResult;
import com.ibm.cognos.cm.ecm.cmis.CMISID;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.CMISQueryOptions;
import com.ibm.cognos.cm.ecm.cmis.CMISQueryResult;
import com.ibm.cognos.cm.ecm.cmis.ContentStream;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomParser;
import com.ibm.cognos.cm.ecm.cmis.atom.EntryBuilder;
import com.ibm.cognos.cm.ecm.cmis.atom.QueryDocumentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.oasisOpen.docs.ns.cmis.core.x200908.QueryDocument;
import org.w3.x2005.atom.EntryDocument;

public class AtomConnection
implements CMISConnection {
    private static final String PATH_SEPERATOR = "/";
    private static final String ROOT_COLLECTION = "ContentFlat";
    private static final String CONTENT_TEMPLATE = "Content";
    private static final String CHECKOUT_COLLECTION = "Checkedout";
    private static final String QUERY_COLLECTION = "Query";
    private final CMISHttpClient client;
    private final AtomParser parser;
    private final EntryBuilder entryBuilder;
    private final QueryDocumentBuilder queryBuilder;
    private final String rootCollectionURI;
    private final String checkOutCollectionURI;
    private final String contentTemplateURI;
    static final String[] CHECK_IN_PROPERTY_NAMES = new String[]{"cmis:name", "cmis:objectId", "cmis:versionSeriesId", "cmis:versionSeriesCheckedOutId"};

    public AtomConnection(CMISHttpClient client) {
        this(client, AtomParser.getInstance(), EntryBuilder.getInstance(), QueryDocumentBuilder.getInstance());
    }

    AtomConnection(CMISHttpClient client, AtomParser parser, EntryBuilder entryBuilder, QueryDocumentBuilder queryBuilder) {
        this.client = client;
        this.parser = parser;
        this.entryBuilder = entryBuilder;
        this.rootCollectionURI = client.getBaseURI() + ROOT_COLLECTION;
        this.checkOutCollectionURI = client.getBaseURI() + CHECKOUT_COLLECTION;
        this.contentTemplateURI = client.getBaseURI() + CONTENT_TEMPLATE;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public CMISID createFolder(CMISID parent, Collection<CMISProperty> properties) {
        return this.createCMISObject(parent, properties).getID();
    }

    @Override
    public CMISID createDocument(CMISID parent, Collection<CMISProperty> properties) {
        return this.createCMISObject(parent, properties).getID();
    }

    @Override
    public CMISID createDocument(CMISID parent, Collection<CMISProperty> properties, ContentStream contentStream) {
        CMISObject object = this.createCMISObject(parent, properties);
        object = this.checkOut(object);
        CMISDocument document = (CMISDocument)object;
        document.setContentStream(contentStream);
        object = this.checkIn(object);
        return object.getID();
    }

    @Override
    public CMISID updateDocumentContent(CMISDocument document, ContentStream contentStream) {
        CMISDocument pwcDocument = (CMISDocument)this.checkOut(document);
        pwcDocument.setContentStream(contentStream);
        CMISObject object = this.checkIn(pwcDocument);
        return object.getID();
    }

    @Override
    public CMISObject getObject(CMISID id) {
        String uri = this.client.getBaseURI() + CONTENT_TEMPLATE + PATH_SEPERATOR + id.getValue();
        return this.getCMISObject(uri);
    }

    @Override
    public CMISObject getObjectByPath(String path) {
        String uri = this.client.getBaseURI() + CONTENT_TEMPLATE + PATH_SEPERATOR + path;
        return this.getCMISObject(uri);
    }

    @Override
    public CMISQueryResult query(String query, CMISQueryOptions options) {
        String uri = this.client.getBaseURI() + QUERY_COLLECTION;
        QueryDocument document = this.queryBuilder.buildDocument(query, options);
        CMISHttpResult result = this.client.postResource(uri, document.xmlText(), "application/cmisquery+xml");
        return this.parser.parseFeedStream(result.getResponseStream(), this.client);
    }

    private CMISObject createCMISObject(CMISID parent, Collection<CMISProperty> properties) {
        String uri = this.rootCollectionURI + PATH_SEPERATOR + parent.getValue();
        return this.postEntry(properties, uri);
    }

    private CMISObject checkOut(CMISObject obj) {
        return this.postEntry(obj.getProperties(), this.checkOutCollectionURI);
    }

    private CMISObject postEntry(Collection<CMISProperty> properties, String uri) {
        EntryDocument doc = this.entryBuilder.build(this.client.getUserName(), properties);
        CMISHttpResult result = this.client.postResource(uri, doc.xmlText(), "application/atom+xml;type=entry");
        return this.buildObjectFromResult(result);
    }

    private CMISObject checkIn(CMISObject obj) {
        List<CMISProperty> objProps = this.getCheckinProps(obj);
        EntryDocument pwcEntry = this.entryBuilder.build(this.client.getUserName(), objProps);
        String uri = this.contentTemplateURI + PATH_SEPERATOR + obj.getID().getValue();
        CMISHttpResult result = this.client.checkinAtomEntry(uri, pwcEntry.xmlText());
        return this.buildObjectFromResult(result);
    }

    private List<CMISProperty> getCheckinProps(CMISObject obj) {
        ArrayList<CMISProperty> objProps = new ArrayList<CMISProperty>(CHECK_IN_PROPERTY_NAMES.length);
        for (String checkInPropName : CHECK_IN_PROPERTY_NAMES) {
            CMISProperty prop = obj.getProperty(checkInPropName);
            if (prop == null) continue;
            objProps.add(prop);
        }
        return objProps;
    }

    private CMISObject getCMISObject(String uri) {
        CMISHttpResult result = this.client.getResource(uri);
        return this.buildObjectFromResult(result);
    }

    private CMISObject buildObjectFromResult(CMISHttpResult result) {
        CMISObject resultObject = this.parser.parseEntryStream(result.getResponseStream(), this.client);
        result.release();
        return resultObject;
    }
}

