/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.atom;

import com.ibm.cognos.cm.ecm.cmis.CMISBaseType;
import com.ibm.cognos.cm.ecm.cmis.CMISDocument;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpClient;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpResult;
import com.ibm.cognos.cm.ecm.cmis.CMISID;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.ContentStream;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomObject;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;

class AtomDocumentObject
extends AtomObject
implements CMISDocument {
    private static final String EDIT_MEDIA_REL = "edit-media";

    AtomDocumentObject(CMISID id, String name, String type, CMISBaseType baseType, Map<String, CMISProperty> properties, Map<String, String> links, CMISHttpClient client) {
        super(id, name, type, baseType, properties, links, client);
    }

    @Override
    public InputStream getContentStream() {
        String editMedia = this.getLinkByRel(EDIT_MEDIA_REL);
        if (null == editMedia) {
            return null;
        }
        CMISHttpResult result = this.getClient().getResource(editMedia);
        return result.getResponseStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContentStream(ContentStream stream) {
        try {
            String mimeType = stream.getContentMimeType();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            String editMedia = this.getLinkByRel(EDIT_MEDIA_REL);
            CMISHttpResult result = this.getClient().putResourceAsStream(editMedia, mimeType, stream.getContentStream());
            result.release();
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream.getContentStream());
            }
        }
    }
}

