/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.atom;

import com.ibm.cognos.cm.ecm.cmis.CMISBaseType;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpClient;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpResult;
import com.ibm.cognos.cm.ecm.cmis.CMISID;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomParser;
import com.ibm.cognos.cm.ecm.cmis.atom.EntryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3.x2005.atom.EntryDocument;

class AtomObject
implements CMISObject {
    private static final String SELF_REL = "self";
    private final CMISHttpClient client;
    private final EntryBuilder entryBuilder;
    private final AtomParser parser;
    private final CMISID id;
    private final String name;
    private final String type;
    private final CMISBaseType baseType;
    private final Map<String, CMISProperty> properties;
    private final Map<String, String> links;

    AtomObject(CMISID id, String name, String type, CMISBaseType baseType, Map<String, CMISProperty> properties, Map<String, String> links, CMISHttpClient client) {
        this(id, name, type, baseType, properties, links, client, EntryBuilder.getInstance(), AtomParser.getInstance());
    }

    AtomObject(CMISID id, String name, String type, CMISBaseType baseType, Map<String, CMISProperty> properties, Map<String, String> links, CMISHttpClient client, EntryBuilder entryBuilder, AtomParser parser) {
        this.properties = properties;
        this.name = name;
        this.type = type;
        this.baseType = baseType;
        this.id = id;
        this.links = links;
        this.client = client;
        this.entryBuilder = entryBuilder;
        this.parser = parser;
    }

    String getLinkByRel(String rel) {
        return this.links.get(rel);
    }

    CMISHttpClient getClient() {
        return this.client;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CMISID getID() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<CMISProperty> getProperties() {
        return new ArrayList<CMISProperty>(this.properties.values());
    }

    @Override
    public CMISBaseType getBaseType() {
        return this.baseType;
    }

    @Override
    public CMISProperty getProperty(String id) {
        return this.properties.get(id);
    }

    @Override
    public CMISObject updateProperties(Collection<CMISProperty> properties) {
        return this.putEntry(properties, this.getLinkByRel(SELF_REL));
    }

    private CMISObject putEntry(Collection<CMISProperty> properties, String uri) {
        EntryDocument doc = this.entryBuilder.build(this.client.getUserName(), properties);
        CMISHttpResult result = this.client.putResource(uri, "application/atom+xml;type=entry", doc.xmlText());
        return this.buildObjectFromResult(result);
    }

    private CMISObject buildObjectFromResult(CMISHttpResult result) {
        CMISObject resultObject = this.parser.parseEntryStream(result.getResponseStream(), this.client);
        result.release();
        return resultObject;
    }
}

