/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.atom;

import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.ecm.cmis.CMISException;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpClient;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyType;
import com.ibm.cognos.cm.ecm.cmis.CMISQueryResult;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomQueryResult;
import com.ibm.cognos.cm.ecm.cmis.atom.CMISObjectBuilder;
import com.ibm.cognos.cm.ecm.cmis.atom.CMISObjectBuilderProvider;
import com.ibm.cognos.cm.ecm.cmis.atom.ValueParser;
import com.ibm.cognos.cm.ecm.util.CMISRepositoryErrors;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.xmlbeans.GDate;

class AtomParser {
    private static final String ENTRY_ELEMENT = "entry";
    private static final String LINK_ELEMENT = "link";
    private static final String PROPERTY_DATE_TIME_ELEMENT = "propertyDateTime";
    private static final String PROPERTY_BOOLEAN_ELEMENT = "propertyBoolean";
    private static final String PROPERTY_STRING_ELEMENT = "propertyString";
    private static final String PROPERTY_INTEGER_ELEMENT = "propertyInteger";
    private static final String PROPERTY_ID_ELEMENT = "propertyId";
    private static final String VALUE_ELEMENT = "value";
    private static final String ATTR_DEFINITION_ID = "propertyDefinitionId";
    private static final String ATTR_QUERY_NAME = "queryName";
    private static final String ATTR_REL = "rel";
    private static final String ATTR_HREF = "href";
    private static final String NEXT_REL_TYPE = "next";
    private static final AtomParser INSTANCE = new AtomParser();
    private final Map<String, ValueParser<?>> parserMap = new HashMap(6, 1.0f);
    private final Map<String, CMISPropertyType> typeMap;
    private final CMISObjectBuilderProvider builderProvider;
    private final CMISPropertyProvider propertyProvider;

    AtomParser() {
        this(new CMISObjectBuilderProvider(), new CMISPropertyProvider());
    }

    AtomParser(CMISObjectBuilderProvider builderProvider, CMISPropertyProvider propertyProvider) {
        this.parserMap.put(PROPERTY_ID_ELEMENT, new StringParser());
        this.parserMap.put(PROPERTY_STRING_ELEMENT, new StringParser());
        this.parserMap.put(PROPERTY_DATE_TIME_ELEMENT, new CalendarParser());
        this.parserMap.put(PROPERTY_BOOLEAN_ELEMENT, new BooleanParser());
        this.parserMap.put(PROPERTY_INTEGER_ELEMENT, new IntegerParser());
        this.typeMap = new HashMap<String, CMISPropertyType>(6, 1.0f);
        this.typeMap.put(PROPERTY_ID_ELEMENT, CMISPropertyType.ID);
        this.typeMap.put(PROPERTY_STRING_ELEMENT, CMISPropertyType.STRING);
        this.typeMap.put(PROPERTY_DATE_TIME_ELEMENT, CMISPropertyType.DATETIME);
        this.typeMap.put(PROPERTY_BOOLEAN_ELEMENT, CMISPropertyType.BOOLEAN);
        this.typeMap.put(PROPERTY_INTEGER_ELEMENT, CMISPropertyType.INTEGER);
        this.builderProvider = builderProvider;
        this.propertyProvider = propertyProvider;
    }

    CMISObject parseEntryStream(InputStream stream, CMISHttpClient client) {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(stream);
            CMISObject obj = this.parseEntryElement(reader, client);
            reader.close();
            return obj;
        }
        catch (XMLStreamException e) {
            throw new CMISException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.invalidCMISEntry), e);
        }
    }

    private CMISObject parseEntryElement(XMLStreamReader reader, CMISHttpClient client) throws XMLStreamException {
        CMISObjectBuilder builder = this.builderProvider.getBuilder(client);
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String localName = reader.getLocalName();
                    if (this.typeMap.containsKey(localName)) {
                        CMISProperty prop = this.parseProperty(reader, this.parserMap.get(localName), localName, this.typeMap.get(localName));
                        builder.addProperty(prop);
                        break;
                    }
                    if (!reader.getLocalName().equals(LINK_ELEMENT)) break;
                    String rel = reader.getAttributeValue(null, ATTR_REL);
                    String href = reader.getAttributeValue(null, ATTR_HREF);
                    builder.addLink(rel, href);
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(ENTRY_ELEMENT)) break;
                    return builder.toCMISObject();
                }
            }
        }
        throw new CMISException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.invalidCMISEntry));
    }

    CMISQueryResult parseFeedStream(InputStream stream, CMISHttpClient client) {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(stream);
            AtomQueryResult result = new AtomQueryResult();
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        if (reader.getLocalName().equals(ENTRY_ELEMENT)) {
                            result.addObject(this.parseEntryElement(reader, client));
                            break;
                        }
                        if (!reader.getLocalName().equals(LINK_ELEMENT) || !NEXT_REL_TYPE.equals(reader.getAttributeValue(null, ATTR_REL))) break;
                        result.setHasMorePages();
                    }
                }
            }
            reader.close();
            return result;
        }
        catch (XMLStreamException e) {
            throw new CMISException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.invalidCMISEntry), e);
        }
    }

    private CMISProperty parseProperty(XMLStreamReader reader, ValueParser<?> parser, String endTag, CMISPropertyType type) throws XMLStreamException {
        String name = reader.getAttributeValue(null, ATTR_QUERY_NAME);
        String definition = reader.getAttributeValue(null, ATTR_DEFINITION_ID);
        CMISProperty prop = this.propertyProvider.createProperty(name, definition, type);
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals(VALUE_ELEMENT)) break;
                    String value = reader.getElementText();
                    prop.addValue(parser.parseValue(value));
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(endTag)) break;
                    return prop;
                }
            }
        }
        throw new CMISException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.invalidCMISEntry));
    }

    static AtomParser getInstance() {
        return INSTANCE;
    }

    class CalendarParser
    implements ValueParser<Calendar> {
        CalendarParser() {
        }

        @Override
        public Calendar parseValue(String val) {
            GDate date = new GDate((CharSequence)val);
            return date.getCalendar();
        }
    }

    class BooleanParser
    implements ValueParser<Boolean> {
        BooleanParser() {
        }

        @Override
        public Boolean parseValue(String val) {
            if ("true".equalsIgnoreCase(val) || "1".equals(val)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(val) || "0".equals(val)) {
                return Boolean.FALSE;
            }
            throw new CMISException(new Message((Resource.Id)CMISRepositoryErrors.CRP_REP.invalidCMISEntry));
        }
    }

    class IntegerParser
    implements ValueParser<Integer> {
        IntegerParser() {
        }

        @Override
        public Integer parseValue(String val) {
            return Integer.valueOf(val);
        }
    }

    class StringParser
    implements ValueParser<String> {
        StringParser() {
        }

        @Override
        public String parseValue(String val) {
            return val;
        }
    }
}

