/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.atom;

import com.ibm.cognos.cm.ecm.cmis.CMISBaseType;
import com.ibm.cognos.cm.ecm.cmis.CMISHttpClient;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomCMISID;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomDocumentObject;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomFolderObject;
import com.ibm.cognos.cm.ecm.cmis.atom.AtomObject;
import com.ibm.cognos.cm.ecm.cmis.atom.PseudoAtomObject;
import java.util.HashMap;
import java.util.Map;

class CMISObjectBuilder {
    private Map<String, CMISProperty> propertyMap;
    private Map<String, String> linkMap = new HashMap<String, String>();
    private CMISHttpClient client;

    CMISObjectBuilder(CMISHttpClient client) {
        this.propertyMap = new HashMap<String, CMISProperty>();
        this.client = client;
    }

    void addProperty(CMISProperty property) {
        this.propertyMap.put(property.getName(), property);
    }

    void addLink(String rel, String href) {
        this.linkMap.put(rel, href);
    }

    private boolean isPseudoObject() {
        return !this.propertyMap.containsKey("cmis:baseTypeId") || !this.propertyMap.containsKey("cmis:objectId") || !this.propertyMap.containsKey("cmis:objectTypeId") || !this.propertyMap.containsKey("cmis:name");
    }

    CMISObject toCMISObject() {
        if (this.isPseudoObject()) {
            return new PseudoAtomObject(this.propertyMap);
        }
        CMISBaseType type = CMISBaseType.fromValue(this.propertyMap.get("cmis:baseTypeId").getValueAsString());
        String objectType = this.propertyMap.get("cmis:objectTypeId").getValueAsString();
        AtomCMISID id = new AtomCMISID(this.propertyMap.get("cmis:objectId").getValueAsString());
        String name = this.propertyMap.get("cmis:name").getValueAsString();
        switch (type) {
            case DOCUMENT: {
                return new AtomDocumentObject(id, name, objectType, type, this.propertyMap, this.linkMap, this.client);
            }
            case FOLDER: {
                return new AtomFolderObject(id, name, objectType, type, this.propertyMap, this.linkMap, this.client);
            }
        }
        return new AtomObject(id, name, objectType, type, this.propertyMap, this.linkMap, this.client);
    }
}

