/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.atom;

import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.atom.CalendarProvider;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.oasisOpen.docs.ns.cmis.core.x200908.CmisObjectType;
import org.oasisOpen.docs.ns.cmis.core.x200908.CmisPropertiesType;
import org.oasisOpen.docs.ns.cmis.core.x200908.CmisPropertyBoolean;
import org.oasisOpen.docs.ns.cmis.core.x200908.CmisPropertyDateTime;
import org.oasisOpen.docs.ns.cmis.core.x200908.CmisPropertyId;
import org.oasisOpen.docs.ns.cmis.core.x200908.CmisPropertyInteger;
import org.oasisOpen.docs.ns.cmis.core.x200908.CmisPropertyString;
import org.oasisOpen.docs.ns.cmis.restatom.x200908.ObjectDocument;
import org.w3.x2005.atom.AtomDateConstruct;
import org.w3.x2005.atom.AtomPersonConstruct;
import org.w3.x2005.atom.EntryDocument;
import org.w3.x2005.atom.EntryType;

class EntryBuilder {
    private static final EntryBuilder INSTANCE = new EntryBuilder();
    private final CalendarProvider provider;

    EntryBuilder() {
        this(CalendarProvider.getInstance());
    }

    EntryBuilder(CalendarProvider provider) {
        this.provider = provider;
    }

    public EntryDocument build(String author, Collection<CMISProperty> properties) {
        EntryDocument entryDoc = EntryDocument.Factory.newInstance();
        EntryType entry = entryDoc.addNewEntry();
        this.setFeedEntries(entry, properties, author);
        CmisObjectType object = this.createCmisObjectType(properties);
        XmlCursor entryCursor = entry.newCursor();
        entryCursor.toEndToken();
        XmlCursor objectCursor = object.newCursor();
        objectCursor.toStartDoc();
        objectCursor.toNextToken();
        objectCursor.moveXml(entryCursor);
        return entryDoc;
    }

    private void setFeedEntries(EntryType entry, Collection<CMISProperty> properties, String author) {
        AtomPersonConstruct atomPersonConstruct = entry.addNewAuthor();
        atomPersonConstruct.setName(author);
        entry.addNewTitle().set((XmlObject)this.createXmlString(this.getObjectName(properties)));
        AtomDateConstruct atomDateConstruct = entry.addNewUpdated();
        atomDateConstruct.setCalendarValue(this.provider.getCalender());
    }

    private String getObjectName(Collection<CMISProperty> properties) {
        for (CMISProperty property : properties) {
            if (!property.getName().equalsIgnoreCase("cmis:name")) continue;
            return property.getValueAsString();
        }
        throw new IllegalArgumentException();
    }

    private CmisObjectType createCmisObjectType(Collection<CMISProperty> properties) {
        ObjectDocument oDoc = ObjectDocument.Factory.newInstance();
        CmisObjectType object = oDoc.addNewObject();
        CmisPropertiesType propertiesType = object.addNewProperties();
        for (CMISProperty property : properties) {
            this.addPropertyToEntry(property, propertiesType);
        }
        return object;
    }

    private void addPropertyToEntry(CMISProperty property, CmisPropertiesType propertiesType) {
        switch (property.getPropertyType()) {
            case ID: {
                this.addIDProperty(property, propertiesType);
                break;
            }
            case BOOLEAN: {
                this.addBooleanProperty(property, propertiesType);
                break;
            }
            case DATETIME: {
                this.addDateProperty(property, propertiesType);
                break;
            }
            case STRING: {
                this.addStringProperty(property, propertiesType);
                break;
            }
            case INTEGER: {
                this.addIntegerProperty(property, propertiesType);
                break;
            }
            default: {
                throw new IllegalArgumentException("CMIS property type " + property.getPropertyType().toString() + " is not supported.");
            }
        }
    }

    private void addStringProperty(CMISProperty property, CmisPropertiesType propertiesType) {
        CmisPropertyString slprop = propertiesType.addNewPropertyString();
        slprop.setPropertyDefinitionId((XmlAnySimpleType)this.createXmlString(property.getDefinitonID()));
        slprop.setQueryName((XmlAnySimpleType)this.createXmlString(property.getName()));
        if (property.getValueCount() > 0) {
            String[] propVals;
            for (String str : propVals = property.getValuesAs(new String[property.getValueCount()])) {
                slprop.addValue(str);
            }
        }
    }

    private void addIntegerProperty(CMISProperty property, CmisPropertiesType propertiesType) {
        CmisPropertyInteger slprop = propertiesType.addNewPropertyInteger();
        slprop.setPropertyDefinitionId((XmlAnySimpleType)this.createXmlString(property.getDefinitonID()));
        slprop.setQueryName((XmlAnySimpleType)this.createXmlString(property.getName()));
        if (property.getValueCount() > 0) {
            Integer[] propVals;
            for (Integer intValue : propVals = property.getValuesAs(new Integer[property.getValueCount()])) {
                slprop.addValue(BigInteger.valueOf(intValue.intValue()));
            }
        }
    }

    private void addDateProperty(CMISProperty property, CmisPropertiesType propertiesType) {
        CmisPropertyDateTime dprop = propertiesType.addNewPropertyDateTime();
        dprop.setPropertyDefinitionId((XmlAnySimpleType)this.createXmlString(property.getDefinitonID()));
        dprop.setQueryName((XmlAnySimpleType)this.createXmlString(property.getName()));
        if (property.getValueCount() > 0) {
            Calendar[] calPropVals;
            for (Calendar cal : calPropVals = property.getValuesAs(new Calendar[property.getValueCount()])) {
                dprop.addValue(cal);
            }
        }
    }

    private void addBooleanProperty(CMISProperty property, CmisPropertiesType propertiesType) {
        CmisPropertyBoolean bprop = propertiesType.addNewPropertyBoolean();
        bprop.setPropertyDefinitionId((XmlAnySimpleType)this.createXmlString(property.getDefinitonID()));
        bprop.setQueryName((XmlAnySimpleType)this.createXmlString(property.getName()));
        if (property.getValueCount() > 0) {
            Boolean[] boolPropVals;
            for (Boolean bool : boolPropVals = property.getValuesAs(new Boolean[property.getValueCount()])) {
                bprop.addValue(bool.booleanValue());
            }
        }
    }

    private void addIDProperty(CMISProperty property, CmisPropertiesType propertiesType) {
        CmisPropertyId propertyId = propertiesType.addNewPropertyId();
        propertyId.setPropertyDefinitionId((XmlAnySimpleType)this.createXmlString(property.getDefinitonID()));
        propertyId.setQueryName((XmlAnySimpleType)this.createXmlString(property.getName()));
        if (property.getValueCount() > 0) {
            String[] idPropVals;
            for (String str : idPropVals = property.getValuesAs(new String[property.getValueCount()])) {
                propertyId.addValue(str);
            }
        }
    }

    private XmlString createXmlString(String value) {
        XmlString string = XmlString.Factory.newInstance();
        string.setStringValue(value);
        return string;
    }

    static EntryBuilder getInstance() {
        return INSTANCE;
    }
}

