/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.ibm.cognos.cm.ecm.cmis.CMISConnection;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISQueryOptions;
import com.ibm.cognos.cm.ecm.cmis.CMISQueryResult;
import com.ibm.cognos.cm.ecm.cmis.query.Query;
import com.ibm.cognos.cm.ecm.cmis.query.QuerySerializer;
import com.ibm.cognos.cm.ecm.cmis.query.ResultProcessor;
import java.util.Collection;
import java.util.Collections;

public class DefaultQuery
implements Query {
    private final Collection<IRepositoryObjectProperty> returnProperties;
    private final QuerySerializer querySerializer;
    private final String executionCondition;
    private final ResultProcessor resultProcessor;

    DefaultQuery(Collection<IRepositoryObjectProperty> returnProperties, QuerySerializer querySerializer, ResultProcessor resultProcessor, String executionCondition) {
        this.returnProperties = returnProperties;
        this.querySerializer = querySerializer;
        this.executionCondition = executionCondition;
        this.resultProcessor = resultProcessor;
    }

    @Override
    public Iterable<CMISObject> execute(CMISConnection connection, IQueryParameters parameters) {
        if (!this.meetsExecutionCondition(parameters)) {
            return Collections.emptyList();
        }
        String text = this.querySerializer.getQueryText(parameters);
        int skipItems = this.getMandatoryIntegerQueryParameterValue(parameters, "skipItems", 0);
        int maxCount = this.getMandatoryIntegerQueryParameterValue(parameters, "maxCount", 1);
        CMISQueryOptions cmisQueryOptions = new CMISQueryOptions();
        cmisQueryOptions.setMaxItems(maxCount);
        cmisQueryOptions.setSkipCount(skipItems);
        CMISQueryResult queryResult = connection.query(text, cmisQueryOptions);
        return this.resultProcessor.process(queryResult);
    }

    private boolean meetsExecutionCondition(IQueryParameters queryParameters) {
        boolean result = true;
        if (this.executionCondition != null && !this.executionCondition.isEmpty()) {
            Object value;
            IQueryParameter parameter = queryParameters.getParameter(this.executionCondition);
            result = parameter != null ? (value = parameter.getValue()) instanceof Boolean && (Boolean)value != false : false;
        }
        return result;
    }

    @Override
    public Collection<IRepositoryObjectProperty> getReturnProperties() {
        return this.returnProperties;
    }

    private int getMandatoryIntegerQueryParameterValue(IQueryParameters parameters, String parameterName, Integer defaultValue) {
        IQueryParameter parameter = parameters.getParameter(parameterName);
        if (parameter == null) {
            return defaultValue;
        }
        Object parameterValue = parameter.getValue();
        if (!(parameterValue instanceof Integer)) {
            throw new IllegalStateException("expected an Integer value for query parameter " + parameterName);
        }
        return (Integer)parameterValue;
    }
}

