/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.ibm.cognos.cm.ecm.cmis.CMISConnection;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.query.Query;
import com.ibm.cognos.cm.ecm.cmis.query.QueryHandler;
import com.ibm.cognos.cm.ecm.cmis.query.QueryParameterExtractor;
import com.ibm.cognos.cm.ecm.cmis.query.QueryResultBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DefaultQueryHandler
implements QueryHandler {
    private final QueryResultBuilder resultBuilder;
    private final List<Query> queries;
    private final QueryParameterExtractor queryParameterExtractor;

    DefaultQueryHandler(List<Query> queries, QueryResultBuilder resultBuilder, QueryParameterExtractor queryParameterExtractor) {
        this.queries = queries;
        this.queryParameterExtractor = queryParameterExtractor;
        this.resultBuilder = resultBuilder;
    }

    @Override
    public IQueryResult execute(CMISConnection connection, IQueryParameters parameters, Properties options) {
        Iterable<CMISObject> cmisResult = this.executeQueries(connection, parameters);
        return this.resultBuilder.build(cmisResult);
    }

    protected Iterable<CMISObject> executeQueries(CMISConnection connection, IQueryParameters queryParameters) {
        Iterable<CMISObject> cmisResult = null;
        for (Query query : this.queries) {
            cmisResult = query.execute(connection, queryParameters);
            this.updateQueryParameters(query, cmisResult, queryParameters);
        }
        return cmisResult;
    }

    protected void updateQueryParameters(Query query, Iterable<CMISObject> cmisResult, IQueryParameters queryParameters) {
        Collection<IRepositoryObjectProperty> returnProperties = query.getReturnProperties();
        IQueryParameters newQueryParameters = this.queryParameterExtractor.extractParameters(cmisResult, returnProperties);
        Set parameterSet = newQueryParameters.getParameters();
        if (parameterSet != null && parameterSet.size() > 0) {
            for (IQueryParameter newParameter : parameterSet) {
                queryParameters.put(newParameter);
            }
        }
    }
}

