/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.ibm.cognos.cm.ecm.cmis.CMISConnection;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.cmis.query.PseudoResultObject;
import com.ibm.cognos.cm.ecm.cmis.query.Query;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class GetIdentitiesQuery
implements Query {
    private final Collection<IRepositoryObjectProperty> returnProperties;
    private final CMISPropertyProvider propertyProvider;
    private final String executionCondition;
    private static final String IDENTITY_LIST = "identityList";

    GetIdentitiesQuery(Collection<IRepositoryObjectProperty> returnProperties, String executionCondition, CMISPropertyProvider propertyProvider) {
        this.returnProperties = returnProperties;
        this.executionCondition = executionCondition;
        this.propertyProvider = propertyProvider;
    }

    @Override
    public Iterable<CMISObject> execute(CMISConnection connection, IQueryParameters parameters) {
        if (!this.meetsExecutionCondition(parameters)) {
            return Collections.emptyList();
        }
        Identity identity = this.getIdentityParameter(parameters);
        if (identity == null) {
            return Collections.emptyList();
        }
        String[] identities = identity.getIdentities();
        List<String> identityList = Arrays.asList(identities);
        Collections.sort(identityList);
        HashMap<String, CMISProperty> properties = new HashMap<String, CMISProperty>();
        CMISProperty property = this.propertyProvider.createProperty(IDENTITY_LIST, IDENTITY_LIST, null);
        property.addValue(identityList);
        properties.put(IDENTITY_LIST, property);
        PseudoResultObject requestedObject = new PseudoResultObject(properties);
        return Arrays.asList(requestedObject);
    }

    @Override
    public Collection<IRepositoryObjectProperty> getReturnProperties() {
        return this.returnProperties;
    }

    private boolean meetsExecutionCondition(IQueryParameters queryParameters) {
        IQueryParameter parameter = queryParameters.getParameter(this.executionCondition);
        if (parameter == null) {
            return false;
        }
        Object value = parameter.getValue();
        return value instanceof Boolean && (Boolean)value != false;
    }

    private Identity getIdentityParameter(IQueryParameters parameters) {
        IQueryParameter identityParameter = parameters.getParameter("identity");
        Identity identity = null;
        if (identityParameter != null) {
            identity = (Identity)identityParameter.getValue();
        }
        return identity;
    }
}

