/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.ibm.cognos.cm.ecm.cmis.CMISConnection;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyType;
import com.ibm.cognos.cm.ecm.cmis.query.PseudoResultObject;
import com.ibm.cognos.cm.ecm.cmis.query.Query;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

class IsNotAdminQuery
implements Query {
    private final AccessControlHelper acHelper;
    private final Collection<IRepositoryObjectProperty> returnProperties;
    private final CMISPropertyProvider propertyProvider;
    private static final String IS_NOT_ADMIN = "isNotAdmin";

    IsNotAdminQuery(Collection<IRepositoryObjectProperty> returnProperties, AccessControlHelper acHelper, CMISPropertyProvider propertyProvider) {
        this.returnProperties = returnProperties;
        this.acHelper = acHelper;
        this.propertyProvider = propertyProvider;
    }

    @Override
    public Iterable<CMISObject> execute(CMISConnection connection, IQueryParameters parameters) {
        Identity identity = this.getIdentityParameter(parameters);
        if (identity == null) {
            return Collections.emptyList();
        }
        boolean result = !this.acHelper.isAdministrator(identity);
        HashMap<String, CMISProperty> properties = new HashMap<String, CMISProperty>();
        CMISProperty property = this.propertyProvider.createProperty(IS_NOT_ADMIN, IS_NOT_ADMIN, CMISPropertyType.BOOLEAN);
        property.addValue(result);
        properties.put(IS_NOT_ADMIN, property);
        PseudoResultObject requestedObject = new PseudoResultObject(properties);
        return Arrays.asList(requestedObject);
    }

    @Override
    public Collection<IRepositoryObjectProperty> getReturnProperties() {
        return this.returnProperties;
    }

    private Identity getIdentityParameter(IQueryParameters parameters) {
        IQueryParameter identityParameter = parameters.getParameter("identity");
        Identity identity = null;
        if (identityParameter != null) {
            identity = (Identity)identityParameter.getValue();
        }
        return identity;
    }
}

