/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IPropertyValueHandler;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.QueryParameter;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.cmis.query.PseudoResultObject;
import com.ibm.cognos.cm.ecm.cmis.query.ResultProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ObjectsToListPorcessor
implements ResultProcessor {
    private final Collection<IRepositoryObjectProperty> returnProperties;
    private final CMISPropertyProvider propertyProvider;

    ObjectsToListPorcessor(Collection<IRepositoryObjectProperty> returnProperties, CMISPropertyProvider propertyProvider) {
        this.returnProperties = returnProperties;
        this.propertyProvider = propertyProvider;
    }

    @Override
    public Iterable<CMISObject> process(Iterable<CMISObject> cmisObjects) {
        HashMap<String, CMISProperty> properties = new HashMap<String, CMISProperty>();
        for (IRepositoryObjectProperty returnProperty : this.returnProperties) {
            String returnPropertyRepositoryName = returnProperty.getPropertyName();
            Object value = null;
            value = this.getPropertyValueAsList(returnPropertyRepositoryName, cmisObjects.iterator());
            CMISProperty property = this.propertyProvider.createProperty(returnPropertyRepositoryName, returnPropertyRepositoryName, null);
            property.addValue(value);
            properties.put(returnPropertyRepositoryName, property);
        }
        PseudoResultObject requestedObject = new PseudoResultObject(properties);
        return Arrays.asList(requestedObject);
    }

    private Object getPropertyValueAsList(String returnPropertyName, Iterator<CMISObject> cmisObjectIterator) {
        ArrayList<String> valueList = new ArrayList<String>();
        while (cmisObjectIterator.hasNext()) {
            CMISObject cmisObject = cmisObjectIterator.next();
            Object value = this.getPropertyValue(returnPropertyName, cmisObject);
            if (!(value instanceof String)) continue;
            valueList.add((String)value);
        }
        return valueList;
    }

    void addValueAsParameter(IRepositoryObjectProperty returnProperty, Object value, IQueryParameters parameters) {
        if (value != null) {
            String returnPropertyMetadataName = returnProperty.getPropertyMetadataName();
            DataDescriptor dataDescriptor = new DataDescriptor();
            dataDescriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty(returnPropertyMetadataName, value));
            IPropertyValueHandler valueHandler = returnProperty.getPropertyValueHandler();
            Object newValue = null;
            if (valueHandler != null) {
                newValue = returnProperty.getPropertyValueHandler().getValue((IDataDescriptor)dataDescriptor);
            }
            parameters.put((IQueryParameter)new QueryParameter(returnPropertyMetadataName, newValue));
        }
    }

    Object getPropertyValue(String returnPropertyName, CMISObject cmisObject) {
        CMISProperty cmisProperty;
        Object value = null;
        if (returnPropertyName != null && (cmisProperty = cmisObject.getProperty(returnPropertyName)) != null) {
            value = cmisProperty.getValue();
        }
        return value;
    }
}

