/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IQueryConfiguration;
import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.cmis.query.ContentQuery;
import com.ibm.cognos.cm.ecm.cmis.query.DefaultQuery;
import com.ibm.cognos.cm.ecm.cmis.query.GetIdentitiesQuery;
import com.ibm.cognos.cm.ecm.cmis.query.IsNotAdminQuery;
import com.ibm.cognos.cm.ecm.cmis.query.NoopQueryResultPorcessor;
import com.ibm.cognos.cm.ecm.cmis.query.Query;
import com.ibm.cognos.cm.ecm.cmis.query.QuerySerializer;
import com.ibm.cognos.cm.ecm.cmis.query.ResultProcessor;
import com.ibm.cognos.cm.ecm.cmis.query.UseIdentityQuery;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

public class QueryFactory {
    private final AccessControlHelper accessControlHelper;
    public static final String IS_NOT_ADMIN = "isNotAdmin";
    public static final String USE_IDENTITY = "useIdentity";
    public static final String GET_IDENTITIES = "getIdentities";

    public QueryFactory(AccessControlHelper accessControlHelper) {
        this.accessControlHelper = accessControlHelper;
    }

    public Query create(IQueryConfiguration queryConfiguration) {
        String queryName = queryConfiguration.getName();
        Query result = "getOutputContent".equals(queryName) ? new ContentQuery(queryConfiguration.getProperties().values()) : (IS_NOT_ADMIN.equals(queryName) ? new IsNotAdminQuery(queryConfiguration.getProperties().values(), this.accessControlHelper, new CMISPropertyProvider()) : (USE_IDENTITY.equals(queryName) ? new UseIdentityQuery(queryConfiguration.getProperties().values(), queryConfiguration.getConditionParameterName(), this.accessControlHelper, new CMISPropertyProvider()) : (GET_IDENTITIES.equals(queryName) ? new GetIdentitiesQuery(queryConfiguration.getProperties().values(), queryConfiguration.getConditionParameterName(), new CMISPropertyProvider()) : this.createDefaultQuery(queryConfiguration))));
        return result;
    }

    private Query createDefaultQuery(IQueryConfiguration queryConfiguration) {
        QuerySerializer querySerializer = new QuerySerializer(queryConfiguration);
        String resultProcessorClass = queryConfiguration.getResultProcessorName();
        ResultProcessor resultProcessor = null;
        if (resultProcessorClass != null) {
            try {
                resultProcessor = this.createInstanceFromClassName(resultProcessorClass, queryConfiguration.getProperties().values());
            }
            catch (Exception e) {
                resultProcessor = new NoopQueryResultPorcessor();
            }
        } else {
            resultProcessor = new NoopQueryResultPorcessor();
        }
        return new DefaultQuery(queryConfiguration.getProperties().values(), querySerializer, resultProcessor, queryConfiguration.getConditionParameterName());
    }

    private ResultProcessor createInstanceFromClassName(String resultProcessorClassName, Collection<IRepositoryObjectProperty> returnProperties) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Class<?> resultProcessorClass = Class.forName(resultProcessorClassName);
        Constructor<?> resultProcessorConstructor = resultProcessorClass.getDeclaredConstructor(Collection.class, CMISPropertyProvider.class);
        ResultProcessor resutlProcessor = (ResultProcessor)resultProcessorConstructor.newInstance(returnProperties, new CMISPropertyProvider());
        return resutlProcessor;
    }
}

