/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IQueriesConfiguration;
import com.cognos.cm.repository.plugin.configuration.IQueryConfiguration;
import com.ibm.cognos.cm.ecm.cmis.query.DefaultQueryHandler;
import com.ibm.cognos.cm.ecm.cmis.query.Query;
import com.ibm.cognos.cm.ecm.cmis.query.QueryFactory;
import com.ibm.cognos.cm.ecm.cmis.query.QueryHandler;
import com.ibm.cognos.cm.ecm.cmis.query.QueryParameterExtractor;
import com.ibm.cognos.cm.ecm.cmis.query.QueryResultBuilder;
import java.util.ArrayList;
import java.util.List;

public class QueryHandlerFactory {
    private final IQueriesConfiguration queriesConfiguration;
    private final QueryFactory queryFactory;

    public QueryHandlerFactory(IQueriesConfiguration queriesConfiguration, QueryFactory queryFactory) {
        this.queriesConfiguration = queriesConfiguration;
        this.queryFactory = queryFactory;
    }

    public QueryHandler create(String queryName) {
        IQueryConfiguration queryConfiguration = this.getQueryConfiguration(queryName);
        return this.createQueryHandler(queryConfiguration);
    }

    private QueryHandler createQueryHandler(IQueryConfiguration queryConfiguration) {
        List<Query> queries = this.getQueries(queryConfiguration.getPrerequisiteQueryNames());
        queries.add(this.createQuery(queryConfiguration));
        queries.addAll(this.getQueries(queryConfiguration.getSubsequentQueryNames()));
        QueryResultBuilder queryResultBuilder = new QueryResultBuilder(queryConfiguration);
        return new DefaultQueryHandler(queries, queryResultBuilder, new QueryParameterExtractor());
    }

    private List<Query> getQueries(List<String> queryNames) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (String queryName : queryNames) {
            IQueryConfiguration queryConfiguration = this.getQueryConfiguration(queryName);
            Query query = this.createQuery(queryConfiguration);
            queries.add(query);
        }
        return queries;
    }

    private Query createQuery(IQueryConfiguration queryConfiguration) {
        return this.queryFactory.create(queryConfiguration);
    }

    private IQueryConfiguration getQueryConfiguration(String queryName) {
        IQueryConfiguration queryConfiguration = this.queriesConfiguration.getQuery(queryName);
        if (queryConfiguration == null) {
            throw new IllegalStateException("Unsupported query " + queryName);
        }
        return queryConfiguration;
    }
}

