/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IPropertyValueHandler;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.DefaultQueryParameters;
import com.cognos.cm.repositoryPluginFramework.QueryParameter;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import java.util.Collection;
import java.util.Iterator;

public class QueryParameterExtractor {
    QueryParameterExtractor() {
    }

    public IQueryParameters extractParameters(Iterable<CMISObject> cmisObjects, Collection<IRepositoryObjectProperty> returnProperties) {
        DefaultQueryParameters parameters = new DefaultQueryParameters();
        Iterator<CMISObject> cmisObjectIterator = cmisObjects.iterator();
        if (cmisObjectIterator.hasNext()) {
            this.extractReturnProperties(returnProperties, cmisObjectIterator, (IQueryParameters)parameters);
        }
        return parameters;
    }

    protected void extractReturnProperties(Collection<IRepositoryObjectProperty> returnProperties, Iterator<CMISObject> cmisObjectIterator, IQueryParameters parameters) {
        CMISObject firstObject = cmisObjectIterator.next();
        for (IRepositoryObjectProperty returnProperty : returnProperties) {
            String returnPropertyRepositoryName = returnProperty.getPropertyName();
            Object value = null;
            value = this.getPropertyValue(returnPropertyRepositoryName, firstObject);
            this.addValueAsParameter(returnProperty, value, parameters);
        }
    }

    void addValueAsParameter(IRepositoryObjectProperty returnProperty, Object value, IQueryParameters parameters) {
        if (value != null) {
            String returnPropertyMetadataName = returnProperty.getPropertyMetadataName();
            DataDescriptor dataDescriptor = new DataDescriptor();
            dataDescriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty(returnPropertyMetadataName, value));
            IPropertyValueHandler valueHandler = returnProperty.getPropertyValueHandler();
            Object newValue = null;
            if (valueHandler != null) {
                newValue = valueHandler.getValue((IDataDescriptor)dataDescriptor);
            }
            parameters.put((IQueryParameter)new QueryParameter(returnPropertyMetadataName, newValue));
        }
    }

    Object getPropertyValue(String returnPropertyName, CMISObject cmisObject) {
        Object value = null;
        if (returnPropertyName != null) {
            CMISProperty cmisProperty = cmisObject.getProperty(returnPropertyName);
            value = cmisProperty.getValue();
        }
        return value;
    }
}

