/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IQueryConfiguration;
import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.QueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResultObjects;
import com.ibm.cognos.cm.ecm.cmis.CMISDocument;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.repositoryplugincommon.HeadersPropertyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class QueryResultBuilder {
    private final Map<String, IRepositoryObjectProperty> returnProperties;

    QueryResultBuilder(IQueryConfiguration queryConfiguration) {
        this.returnProperties = queryConfiguration.getProperties();
    }

    public IQueryResult build(Iterable<CMISObject> cmisObjects) {
        ArrayList<IDataDescriptor> dataDescriptorList = new ArrayList<IDataDescriptor>();
        for (CMISObject cmisObject : cmisObjects) {
            if (cmisObject instanceof CMISDocument) {
                dataDescriptorList.add((IDataDescriptor)this.createDataDescriptor((CMISDocument)cmisObject));
                continue;
            }
            dataDescriptorList.add(this.createDataDescriptor(cmisObject));
        }
        return this.buildQueryResult(dataDescriptorList);
    }

    private IDataDescriptor createDataDescriptor(CMISObject cmisObject) {
        DataDescriptor dataDescriptor = new DataDescriptor();
        for (IRepositoryObjectProperty prop : this.returnProperties.values()) {
            Object value = this.getRepositoryPropertyValue(prop.getPropertyName(), cmisObject);
            if (value == null) continue;
            DataDescriptorProperty dataDescriptorProp = new DataDescriptorProperty(prop.getPropertyMetadataName(), value);
            dataDescriptor.addProperty((IDataDescriptorProperty)dataDescriptorProp);
        }
        return dataDescriptor;
    }

    private Object getRepositoryPropertyValue(String returnPropertyRepositoryName, CMISObject cmisObject) {
        CMISProperty cmisProperty;
        Object result = null;
        if (returnPropertyRepositoryName != null && (cmisProperty = cmisObject.getProperty(returnPropertyRepositoryName)) != null) {
            result = cmisProperty.getValue();
        }
        return result;
    }

    private DataDescriptor createDataDescriptor(CMISDocument requestedDocument) {
        DataDescriptor dataDescriptor = new DataDescriptor();
        Map<String, String> headers = this.createResponseHeaders(requestedDocument);
        dataDescriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("headers", headers));
        dataDescriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("contentStream", (Object)requestedDocument.getContentStream()));
        return dataDescriptor;
    }

    private Map<String, String> createResponseHeaders(CMISDocument requestedDocument) {
        String mimeType = this.getStringValue(requestedDocument.getProperty("cmis:contentStreamMimeType"));
        String fileName = this.getStringValue(requestedDocument.getProperty("cmis:contentStreamFileName"));
        String contentLength = this.getStringValue(requestedDocument.getProperty("cmis:contentStreamLength"));
        return HeadersPropertyBuilder.buildResponseHeaders((String)mimeType, null, (String)fileName, (String)contentLength);
    }

    private String getStringValue(CMISProperty cprop) {
        String propValue = "";
        if (cprop != null) {
            propValue = cprop.getValueAsString();
        }
        return propValue;
    }

    private IQueryResult buildQueryResult(List<IDataDescriptor> dataDescriptorList) {
        QueryResultObjects objects = new QueryResultObjects(dataDescriptorList);
        return new QueryResult((IQueryResultObjects)objects, !dataDescriptorList.isEmpty());
    }
}

