/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IQueryConfiguration;
import com.cognos.cm.repository.plugin.configuration.IQueryOptionalClause;
import com.cognos.cm.repository.plugin.configuration.IRepositoryQueryParameterConfiguration;
import com.cognos.cm.repository.plugin.configuration.RepositoryPropertyType;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.ibm.cognos.cm.repositoryplugincommon.XMLGregorianCalendarProvider;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;

public class QuerySerializer {
    private final String originalQueryText;
    private final Map<String, IRepositoryQueryParameterConfiguration> parametersConfiguration;
    private final Map<String, IQueryOptionalClause> clauseObjects;
    private static final String OPENING_BRACKET = "\\$\\{";
    private static final String CLOSING_BRACKET = "\\}";

    QuerySerializer(IQueryConfiguration queryConfiguration) {
        this.originalQueryText = queryConfiguration.getQueryText();
        this.parametersConfiguration = queryConfiguration.getParameters();
        this.clauseObjects = queryConfiguration.getOptionalClauses();
    }

    public String getQueryText(IQueryParameters parameters) {
        this.parametersConfiguration.values();
        String queryText = this.processQueryText(this.originalQueryText, this.parametersConfiguration.values(), parameters);
        queryText = this.processOptionalClauses(queryText, this.clauseObjects, parameters);
        return queryText;
    }

    private String processOptionalClauses(String queryText, Map<String, IQueryOptionalClause> clauseObjects, IQueryParameters parameters) {
        String processedQueryText = queryText;
        for (IQueryOptionalClause clause : clauseObjects.values()) {
            String processedClauseText = this.processClauseText(clause.getClauseText(), clause.getParameters().values(), parameters);
            processedQueryText = processedQueryText.replaceAll(OPENING_BRACKET + clause.getName() + CLOSING_BRACKET, processedClauseText);
        }
        return processedQueryText;
    }

    private String processClauseText(String originalClauseText, Collection<IRepositoryQueryParameterConfiguration> caluseParameters, IQueryParameters parameters) {
        String clauseText = originalClauseText;
        for (IRepositoryQueryParameterConfiguration config : caluseParameters) {
            String paramName = config.getName();
            IQueryParameter parameter = parameters.getParameter(paramName);
            if (parameter != null) {
                String stringValue = this.getStringParameterValue(parameter, config.getType());
                clauseText = this.updateClauseText(paramName, stringValue, clauseText);
                continue;
            }
            return "";
        }
        return clauseText;
    }

    private String updateClauseText(String parameterName, String value, String clauseText) {
        String newCaluseText = clauseText;
        if (value != null) {
            newCaluseText = newCaluseText.replaceAll(OPENING_BRACKET + parameterName + CLOSING_BRACKET, value);
        }
        return newCaluseText;
    }

    private String processQueryText(String queryText, Collection<IRepositoryQueryParameterConfiguration> parameterConfigValues, IQueryParameters parameters) {
        String processedQueryText = queryText;
        for (IRepositoryQueryParameterConfiguration parameterConfiguration : parameterConfigValues) {
            String parameterName = parameterConfiguration.getName();
            IQueryParameter parameter = parameters.getParameter(parameterName);
            String stringValue = this.getStringParameterValue(parameter, parameterConfiguration.getType());
            if ("outputFileClass".equals(parameterName)) {
                stringValue = this.getOutputFileClassName(stringValue);
            }
            if (stringValue == null) continue;
            processedQueryText = this.updateValueInQuery(stringValue, parameterName, processedQueryText);
        }
        return processedQueryText;
    }

    private String updateValueInQuery(String value, String parameterName, String queryText) {
        String newValue = value;
        newValue = newValue.replace("$", "\\$");
        newValue = newValue.replace("{", "\\{");
        newValue = newValue.replace("}", CLOSING_BRACKET);
        return queryText.replaceAll(OPENING_BRACKET + parameterName + CLOSING_BRACKET, newValue);
    }

    private String getStringParameterValue(IQueryParameter parameter, RepositoryPropertyType parameterType) {
        String stringValue = null;
        if (parameter != null) {
            Object parameterValue = parameter.getValue();
            stringValue = this.convertQueryParameterValueToString(parameterType, parameterValue);
        }
        return stringValue;
    }

    private String getOutputFileClassName(String outputClassName) {
        String result = "page".equalsIgnoreCase(outputClassName) ? "OUTPUTPAGE" : "OUTPUTGRAPHIC";
        return result;
    }

    String convertQueryParameterValueToString(RepositoryPropertyType parameterType, Object parameterValue) {
        String stringValue = null;
        switch (parameterType) {
            case STRING: {
                stringValue = (String)parameterValue;
                break;
            }
            case DATETIME: {
                XMLGregorianCalendar gCal = XMLGregorianCalendarProvider.provide((Calendar)((Calendar)parameterValue));
                stringValue = gCal.toXMLFormat();
                break;
            }
            case STRINGLIST: {
                stringValue = this.convertListToString((List)parameterValue);
                break;
            }
            case BOOLEAN: {
                stringValue = String.valueOf(parameterValue);
                break;
            }
            case TENANT_CLAUSE: {
                stringValue = (String)parameterValue;
                stringValue = stringValue.isEmpty() ? "${" + parameterType + "-noTenantID}" : "${" + parameterType + "-useTenantID}";
            }
        }
        return stringValue;
    }

    private String convertListToString(List<String> parameterValue) {
        StringBuilder sb = new StringBuilder();
        ListIterator<String> it = parameterValue.listIterator();
        if (parameterValue.isEmpty()) {
            sb.append("''");
        } else {
            while (it.hasNext()) {
                sb.append("'");
                String item = it.next();
                sb.append(item);
                sb.append("'");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }
}

