/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.cmis.query;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.ibm.cognos.cm.ecm.cmis.CMISConnection;
import com.ibm.cognos.cm.ecm.cmis.CMISObject;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyType;
import com.ibm.cognos.cm.ecm.cmis.query.PseudoResultObject;
import com.ibm.cognos.cm.ecm.cmis.query.Query;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

class UseIdentityQuery
implements Query {
    private final AccessControlHelper acHelper;
    private final Collection<IRepositoryObjectProperty> returnProperties;
    private final CMISPropertyProvider propertyProvider;
    private final String executionCondition;
    private static final String USE_IDENTITY = "useIdentity";

    UseIdentityQuery(Collection<IRepositoryObjectProperty> returnProperties, String executionCondition, AccessControlHelper acHelper, CMISPropertyProvider propertyProvider) {
        this.returnProperties = returnProperties;
        this.executionCondition = executionCondition;
        this.acHelper = acHelper;
        this.propertyProvider = propertyProvider;
    }

    @Override
    public Iterable<CMISObject> execute(CMISConnection connection, IQueryParameters parameters) {
        if (!this.meetsExecutionCondition(parameters)) {
            return Collections.emptyList();
        }
        Identity identity = this.getIdentityParameter(parameters);
        if (identity == null) {
            return Collections.emptyList();
        }
        IQueryParameter ownerParam = parameters.getParameter("owner");
        IQueryParameter hasRecipientsParam = parameters.getParameter("hasRecipients");
        String owner = (String)ownerParam.getValue();
        Boolean hasRecipients = (Boolean)hasRecipientsParam.getValue();
        hasRecipients = hasRecipients != null ? hasRecipients : false;
        boolean isOwner = false;
        try {
            isOwner = this.acHelper.containsAnyCAMID(identity, owner);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        boolean result = hasRecipients != false && !isOwner;
        HashMap<String, CMISProperty> properties = new HashMap<String, CMISProperty>();
        CMISProperty property = this.propertyProvider.createProperty(USE_IDENTITY, USE_IDENTITY, CMISPropertyType.BOOLEAN);
        property.addValue(result);
        properties.put(USE_IDENTITY, property);
        PseudoResultObject requestedObject = new PseudoResultObject(properties);
        return Arrays.asList(requestedObject);
    }

    @Override
    public Collection<IRepositoryObjectProperty> getReturnProperties() {
        return this.returnProperties;
    }

    private boolean meetsExecutionCondition(IQueryParameters queryParameters) {
        IQueryParameter parameter = queryParameters.getParameter(this.executionCondition);
        Object value = parameter.getValue();
        return value instanceof Boolean && (Boolean)value != false;
    }

    private Identity getIdentityParameter(IQueryParameters parameters) {
        IQueryParameter identityParameter = parameters.getParameter("identity");
        Identity identity = null;
        if (identityParameter != null) {
            identity = (Identity)identityParameter.getValue();
        }
        return identity;
    }
}

