/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.connection;

import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IGetDataResults;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IRepositoryDataSizeCounter;
import com.cognos.cm.repositoryPluginAPI.IRepositoryTimer;
import com.cognos.cm.repositoryPluginAPI.OperationResult;
import com.cognos.cm.repositoryPluginAPI.OperationResultSuccess;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.AccessControlHelper;
import com.cognos.cm.repositoryPluginFramework.QueryParameter;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.ecm.cmis.CMISConnection;
import com.ibm.cognos.cm.ecm.cmis.CMISDocument;
import com.ibm.cognos.cm.ecm.cmis.CMISException;
import com.ibm.cognos.cm.ecm.cmis.CMISID;
import com.ibm.cognos.cm.ecm.cmis.ObjectNotFoundException;
import com.ibm.cognos.cm.ecm.cmis.query.QueryFactory;
import com.ibm.cognos.cm.ecm.cmis.query.QueryHandler;
import com.ibm.cognos.cm.ecm.cmis.query.QueryHandlerFactory;
import com.ibm.cognos.cm.ecm.connection.LockCache;
import com.ibm.cognos.cm.ecm.connection.SimpleCache;
import com.ibm.cognos.cm.ecm.meta.CMISArchiveItem;
import com.ibm.cognos.cm.ecm.meta.DataDescriptorProcessor;
import com.ibm.cognos.cm.ecm.util.CMISRepositoryErrors;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;

public abstract class CMISRepositoryConnection
implements RepositoryConnection {
    private static final LockCache<String> FOLDER_LOCK_CACHE = new LockCache(2);
    private static final SimpleCache<String, LockCache<String>> DOCUMENT_LOCK_CACHE = new SimpleCache();
    private static final SimpleCache<String, SimpleCache<String, CMISID>> ID_CACHE = new SimpleCache();
    private final Lock folderCreationLock;
    private final SimpleCache<String, CMISID> cmisIdCache;
    private final LockCache<String> documentCreationLocks;
    private final CMISConnection connection;
    private final QueryHandlerFactory queryHandlerFactory;
    private final DataDescriptorProcessor dataDescriptorProcessor;
    private final String archiveBaseUri;
    private final Properties properties;

    protected CMISRepositoryConnection(String archiveBaseUri, CMISConnection connection, IRepositoryConnectionConfiguration connectionConfiguration, Properties properties) {
        this(archiveBaseUri, connection, new QueryHandlerFactory(connectionConfiguration.getQueryConfiguration(), new QueryFactory(AccessControlHelper.getInstance())), DataDescriptorProcessor.getInstance(connectionConfiguration.getWriteConfiguration()), properties);
    }

    protected CMISRepositoryConnection(String archiveBaseUri, CMISConnection connection, QueryHandlerFactory queryHandlerFactory, DataDescriptorProcessor dataDescriptorProcessor, Properties properties) {
        this.connection = connection;
        this.queryHandlerFactory = queryHandlerFactory;
        this.dataDescriptorProcessor = dataDescriptorProcessor;
        this.archiveBaseUri = archiveBaseUri;
        this.properties = properties;
        String rootPath = properties.getProperty("ROOT");
        String connectionString = archiveBaseUri + rootPath;
        this.folderCreationLock = FOLDER_LOCK_CACHE.get((Object)connectionString);
        this.cmisIdCache = CMISRepositoryConnection.getIdCache(connectionString);
        this.documentCreationLocks = CMISRepositoryConnection.getDocumentLockCache(connectionString);
    }

    private static SimpleCache<String, CMISID> getIdCache(String connectionString) {
        return ID_CACHE.putIfAbsent(connectionString, new SimpleCache());
    }

    private static LockCache<String> getDocumentLockCache(String connectionString) {
        return DOCUMENT_LOCK_CACHE.putIfAbsent(connectionString, new LockCache(2));
    }

    public static final void clearCache() {
        FOLDER_LOCK_CACHE.clear();
        DOCUMENT_LOCK_CACHE.clear();
        ID_CACHE.clear();
    }

    public OperationResult writeData(IDataDescriptor metadata, Properties options) throws RepositoryException {
        if (metadata == null) {
            throw new IllegalStateException("missing option metadata");
        }
        String rootPath = this.getRootPath();
        StringBuilder path = new StringBuilder(rootPath);
        try {
            List<CMISArchiveItem> cmisArchiveItems = this.dataDescriptorProcessor.process(metadata);
            CMISID currentFolderID = this.connection.getObjectByPath(path.toString()).getID();
            for (CMISArchiveItem cmisArchiveItem : cmisArchiveItems) {
                switch (cmisArchiveItem.getBaseType()) {
                    case DOCUMENT: {
                        this.createDocument(path, currentFolderID, cmisArchiveItem);
                        break;
                    }
                    case FOLDER: {
                        currentFolderID = this.createFolder(path, currentFolderID, cmisArchiveItem);
                    }
                }
            }
            return new OperationResultSuccess();
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)CMISRepositoryErrors.CRP_OPF.failedToAddArchive, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CMISID createFolder(StringBuilder path, CMISID currentFolderID, CMISArchiveItem cmisArchiveItem) {
        path.append('/').append(cmisArchiveItem.getName());
        String currentPath = path.toString();
        try {
            this.folderCreationLock.lock();
            if (this.cmisIdCache.containsKey(currentPath)) {
                currentFolderID = this.cmisIdCache.get(currentPath);
            } else {
                currentFolderID = this.connection.getObjectByPath(currentPath).getID();
                this.cmisIdCache.put(currentPath, currentFolderID);
            }
        }
        catch (ObjectNotFoundException e) {
            currentFolderID = this.connection.createFolder(currentFolderID, cmisArchiveItem.getProperties());
            this.cmisIdCache.put(currentPath, currentFolderID);
        }
        finally {
            this.folderCreationLock.unlock();
        }
        return currentFolderID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDocument(StringBuilder path, CMISID folderID, CMISArchiveItem cmisArchiveItem) {
        String documentPath = path.toString() + "/" + cmisArchiveItem.getName();
        Object docLock = this.documentCreationLocks.get((Object)documentPath);
        if (docLock.tryLock()) {
            try {
                CMISDocument document = this.getDocument(documentPath);
                if (document == null) {
                    this.createNewDocument(folderID, cmisArchiveItem);
                } else {
                    this.updateDocument(document, cmisArchiveItem);
                }
            }
            finally {
                docLock.unlock();
            }
        }
    }

    private CMISDocument getDocument(String documentPath) {
        CMISDocument document;
        try {
            document = (CMISDocument)this.connection.getObjectByPath(documentPath);
        }
        catch (ObjectNotFoundException e) {
            document = null;
        }
        return document;
    }

    private CMISID createNewDocument(CMISID currentFolderID, CMISArchiveItem cmisArchiveItem) {
        CMISID documentID = cmisArchiveItem.hasContentStream() ? this.connection.createDocument(currentFolderID, cmisArchiveItem.getProperties(), cmisArchiveItem.getContentStream()) : this.connection.createDocument(currentFolderID, cmisArchiveItem.getProperties());
        return documentID;
    }

    private CMISID updateDocument(CMISDocument document, CMISArchiveItem cmisArchiveItem) {
        document = (CMISDocument)document.updateProperties(cmisArchiveItem.getProperties());
        CMISID documentID = cmisArchiveItem.hasContentStream() ? this.connection.updateDocumentContent(document, cmisArchiveItem.getContentStream()) : document.getID();
        return documentID;
    }

    public IQueryResult queryObjects(String queryName, IQueryParameters parameters, Properties options) throws RepositoryException {
        try {
            QueryHandler queryHandler = this.queryHandlerFactory.create(queryName);
            this.addTenantParameters(parameters);
            return queryHandler.execute(this.connection, parameters, options);
        }
        catch (CMISException e) {
            throw this.createRepositoryException((Exception)((Object)e), CMISRepositoryErrors.CRP_OPF.failedToQueryCMIS);
        }
    }

    private IQueryParameters addTenantParameters(IQueryParameters parameters) {
        String userTenantID = this.properties.getProperty("userTenantID", "");
        String connectionTenantID = this.properties.getProperty("connectionTenantID", "");
        parameters.put((IQueryParameter)new QueryParameter("userTenantID", (Object)userTenantID));
        parameters.put((IQueryParameter)new QueryParameter("connectionTenantID", (Object)connectionTenantID));
        return parameters;
    }

    public String getUrl() {
        return this.archiveBaseUri;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setTimeCounter(IRepositoryTimer timer) {
    }

    public void setDataSizeCounter(IRepositoryDataSizeCounter counter) {
    }

    public void test() throws RepositoryException {
        try {
            String rootPath = this.getRootPath();
            this.connection.getObjectByPath(rootPath);
        }
        catch (Exception e) {
            throw this.createRepositoryException(e, CMISRepositoryErrors.CRP_OPF.failedToTestConnection);
        }
    }

    private String getRootPath() {
        String rootPath = this.properties.getProperty("ROOT");
        if (rootPath == null) {
            throw new IllegalStateException("missing archive root path");
        }
        return rootPath.trim();
    }

    private RepositoryException createRepositoryException(Exception e, Resource.Id id) throws RepositoryException {
        Message msg = new Message(id);
        if (e instanceof RepositoryException) {
            ((RepositoryException)((Object)e)).addDetail(msg);
            throw (RepositoryException)((Object)e);
        }
        RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
        newEx.addDetail(e.getMessage());
        return newEx;
    }

    public void close() {
    }

    public void clean() {
        throw new UnsupportedOperationException();
    }

    public IRepositoryConnectionConfiguration getConnectionConfiguration() {
        throw new UnsupportedOperationException();
    }

    public IGetDataResults getData() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public byte[] fetchReportAccessPolicies(String reportStoreID) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void deleteData(String objectID) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void copyData(String srcObjectID, String destObjectID) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean objectExists(String objectID) {
        throw new UnsupportedOperationException();
    }

    public boolean doesTestPermissions() {
        return false;
    }
}

