/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.meta;

import com.ibm.cognos.cm.ecm.cmis.CMISBaseType;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.ContentStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CMISArchiveItem {
    private final CMISBaseType baseType;
    private final Collection<CMISProperty> properties;
    private final List<CMISArchiveItem> associatedItems;
    private ContentStream contentStream;
    private String name;

    CMISArchiveItem(String name, CMISBaseType baseType, int propCapacity) {
        this.baseType = baseType;
        this.properties = new ArrayList<CMISProperty>(propCapacity);
        this.associatedItems = new ArrayList<CMISArchiveItem>(2);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public CMISBaseType getBaseType() {
        return this.baseType;
    }

    public Collection<CMISProperty> getProperties() {
        return this.properties;
    }

    void addProperty(CMISProperty cmisProp) {
        if (cmisProp != null) {
            String propDefinitionID = cmisProp.getDefinitonID();
            if ("cmis:contentStreamMimeType".equals(propDefinitionID)) {
                this.setContentStreamMimeType(cmisProp);
            } else {
                this.properties.add(cmisProp);
                if ("cmis:name".equals(propDefinitionID)) {
                    this.setName(cmisProp.getValueAsString());
                }
            }
        }
    }

    private void setContentStreamMimeType(CMISProperty cmisProp) {
        if (this.hasContentStream()) {
            String mimeType = this.getMimeTypeValue(cmisProp);
            this.getContentStream().setContentMimeType(mimeType);
        }
    }

    private String getMimeTypeValue(CMISProperty cmisProp) {
        String contentMimeType = cmisProp.getValueAsString();
        int semiColonIdx = contentMimeType.indexOf(59);
        if (semiColonIdx > 0) {
            contentMimeType = contentMimeType.substring(0, semiColonIdx);
        }
        return contentMimeType;
    }

    boolean hasAssociatedItems() {
        return this.associatedItems.size() > 0;
    }

    void addAssociatedItem(CMISArchiveItem associatedItem) {
        this.associatedItems.add(associatedItem);
    }

    List<CMISArchiveItem> getAssociatedItems() {
        return this.associatedItems;
    }

    public boolean hasContentStream() {
        return this.contentStream != null;
    }

    public ContentStream getContentStream() {
        return this.contentStream;
    }

    void setContentStream(ContentStream contentStream) {
        this.contentStream = contentStream;
    }
}

