/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.meta;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectType;
import com.cognos.cm.repository.plugin.configuration.RepositoryPropertyType;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IInputStreamPropertyValue;
import com.cognos.cm.repositoryPluginAPI.IPropertyValueHandler;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.ecm.cmis.CMISBaseType;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyType;
import com.ibm.cognos.cm.ecm.cmis.ContentStream;
import com.ibm.cognos.cm.ecm.meta.CMISArchiveItem;
import com.ibm.cognos.cm.ecm.meta.PropertyBuilder;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

class CMISArchiveItemBuilder {
    private final PropertyBuilder propertyBuilder;

    CMISArchiveItemBuilder(PropertyBuilder propertyBuilder) {
        this.propertyBuilder = propertyBuilder;
    }

    CMISArchiveItem build(IRepositoryObjectType type, IDataDescriptor metadata, InputStream dataStream) throws RepositoryException {
        CMISBaseType cmisType = this.getCMISBaseType(type);
        Collection typeProps = type.getProperties().values();
        int propsSize = typeProps.size();
        CMISArchiveItem cmisArchiveItem = this.createCmisArchiveItem(cmisType, propsSize, dataStream);
        for (IRepositoryObjectProperty typeProp : typeProps) {
            if (RepositoryPropertyType.ASSOCIATED.equals((Object)typeProp.getPropertyType())) {
                CMISArchiveItem associatedItem = this.createAssociatedItem(metadata, typeProp);
                cmisArchiveItem.addAssociatedItem(associatedItem);
                continue;
            }
            CMISProperty cmisProp = this.propertyBuilder.createProperty(typeProp, metadata);
            cmisArchiveItem.addProperty(cmisProp);
        }
        CMISProperty typeProp = this.propertyBuilder.createProperty("cmis:objectTypeId", "cmis:objectTypeId", CMISPropertyType.ID);
        typeProp.addValue(type.getName());
        cmisArchiveItem.addProperty(typeProp);
        return cmisArchiveItem;
    }

    private CMISBaseType getCMISBaseType(IRepositoryObjectType type) {
        CMISBaseType cmisType = type.isFolder() ? CMISBaseType.FOLDER : CMISBaseType.DOCUMENT;
        return cmisType;
    }

    private CMISArchiveItem createCmisArchiveItem(CMISBaseType cmisType, int propsSize, InputStream dataStream) {
        CMISArchiveItem cmisArchiveItem = new CMISArchiveItem(null, cmisType, propsSize);
        if (dataStream != null) {
            ContentStream contentStream = new ContentStream(dataStream, null, null);
            cmisArchiveItem.setContentStream(contentStream);
        }
        return cmisArchiveItem;
    }

    private CMISArchiveItem createAssociatedItem(IDataDescriptor metadata, IRepositoryObjectProperty typeProp) throws RepositoryException {
        IPropertyValueHandler valueHandler = typeProp.getPropertyValueHandler();
        Object associatedDataPropValue = valueHandler.getValue(metadata);
        InputStream associatedData = null;
        if (associatedDataPropValue instanceof IInputStreamPropertyValue) {
            associatedData = ((IInputStreamPropertyValue)associatedDataPropValue).getStream();
        }
        return this.build(typeProp.getAssociatedPropertyObjectType(), metadata, associatedData);
    }

    CMISArchiveItem buildEnclosingItem(IRepositoryObjectProperty locationProp, String name, IDataDescriptor metadata) throws RepositoryException {
        CMISArchiveItem cmisArchiveItem = this.build(locationProp.getEnclosedObjectType(), metadata, null);
        if (cmisArchiveItem.getName() == null) {
            cmisArchiveItem.setName(name);
            CMISProperty cmisProp = this.propertyBuilder.createProperty("cmis:name", "cmis:name", CMISPropertyType.STRING);
            cmisProp.addValue(name);
            cmisArchiveItem.getProperties().add(cmisProp);
        }
        return cmisArchiveItem;
    }

    static CMISArchiveItemBuilder getInstance(CMISPropertyProvider cmisPropProvider, Map<String, String> replacementMap) {
        PropertyBuilder propertyBuilder = new PropertyBuilder(cmisPropProvider, replacementMap);
        return new CMISArchiveItemBuilder(propertyBuilder);
    }
}

