/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.meta;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectType;
import com.cognos.cm.repository.plugin.configuration.IWriteConfiguration;
import com.cognos.cm.repository.plugin.configuration.RepositoryPropertyType;
import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.DataObject;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.meta.CMISArchiveItem;
import com.ibm.cognos.cm.ecm.meta.CMISArchiveItemBuilder;
import com.ibm.cognos.cm.ecm.meta.ObjectTypeHandle;
import com.ibm.cognos.cm.ecm.meta.ObjectTypeHandleProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DataDescriptorProcessor {
    private final ObjectTypeHandleProvider typeHandleProvider;
    private final CMISArchiveItemBuilder cmisArchiveItemBuilder;

    DataDescriptorProcessor(ObjectTypeHandleProvider typeHandleProvider, CMISArchiveItemBuilder cmisArchiveItemBuilder) {
        this.typeHandleProvider = typeHandleProvider;
        this.cmisArchiveItemBuilder = cmisArchiveItemBuilder;
    }

    public List<CMISArchiveItem> process(IDataDescriptor metadata) throws RepositoryException {
        ObjectTypeHandle typeHandle = this.typeHandleProvider.provide(metadata);
        ArrayList<CMISArchiveItem> itemList = new ArrayList<CMISArchiveItem>();
        InputStream outputDataStream = this.getDataStream(metadata);
        this.updateItemList(typeHandle, itemList, metadata, outputDataStream);
        return itemList;
    }

    private InputStream getDataStream(IDataDescriptor metadata) throws RepositoryException {
        InputStream outputDataStream = null;
        IDataDescriptorProperty dataProp = metadata.getProperty("data");
        Object valueObject = null;
        if (dataProp != null && (valueObject = dataProp.getValue()) != null && valueObject instanceof DataObject) {
            outputDataStream = ((DataObject)valueObject).getDataStream();
        }
        return outputDataStream;
    }

    private void updateItemList(ObjectTypeHandle typeHandler, List<CMISArchiveItem> itemList, IDataDescriptor metadata, InputStream data) throws RepositoryException {
        if (typeHandler.hasParent()) {
            this.updateItemList(typeHandler.getParent(), itemList, metadata, null);
        }
        IRepositoryObjectType repositoryType = typeHandler.getType();
        this.addEnclosingItems(repositoryType, itemList, metadata);
        CMISArchiveItem cmisArchiveItem = this.cmisArchiveItemBuilder.build(repositoryType, metadata, data);
        itemList.add(cmisArchiveItem);
        if (cmisArchiveItem.hasAssociatedItems()) {
            itemList.addAll(cmisArchiveItem.getAssociatedItems());
        }
    }

    private void addEnclosingItems(IRepositoryObjectType repositoryType, List<CMISArchiveItem> itemList, IDataDescriptor metadata) throws RepositoryException {
        String locationPropName = repositoryType.getLocationDescriptionPropName();
        if (locationPropName != null) {
            IRepositoryObjectProperty locationProp = (IRepositoryObjectProperty)repositoryType.getProperties().get(locationPropName);
            List<String> locationList = this.getLocationList(locationProp, metadata);
            for (String locationStep : locationList) {
                DataDescriptorProperty itemProp = new DataDescriptorProperty("listItemValue", (Object)locationStep);
                metadata.addProperty((IDataDescriptorProperty)itemProp);
                CMISArchiveItem cmisArchiveItem = this.cmisArchiveItemBuilder.buildEnclosingItem(locationProp, locationStep, metadata);
                itemList.add(cmisArchiveItem);
            }
        }
    }

    private List<String> getLocationList(IRepositoryObjectProperty locationProp, IDataDescriptor metadata) {
        List locationList = null;
        if (locationProp != null) {
            try {
                locationList = (List)locationProp.getPropertyValueHandler().getValue(metadata);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("invalid " + RepositoryPropertyType.STRINGLIST + " object", e);
            }
        }
        if (locationList == null) {
            throw new IllegalStateException("invalid location property");
        }
        return locationList;
    }

    public static DataDescriptorProcessor getInstance(IWriteConfiguration writeConfiguration) {
        ObjectTypeHandleProvider typeHandleProvider = new ObjectTypeHandleProvider(writeConfiguration.getRootObjectType());
        CMISArchiveItemBuilder cmisArchiveItemBuilder = CMISArchiveItemBuilder.getInstance(new CMISPropertyProvider(), writeConfiguration.getCharacterMappings());
        return new DataDescriptorProcessor(typeHandleProvider, cmisArchiveItemBuilder);
    }
}

