/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.meta;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectType;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.ibm.cognos.cm.ecm.meta.ObjectTypeHandle;
import java.util.ArrayList;
import java.util.List;

class ObjectTypeHandleProvider {
    private final List<ObjectTypeHandle> conditionedTypes = new ArrayList<ObjectTypeHandle>();

    ObjectTypeHandleProvider(IRepositoryObjectType rootObjectType) {
        this.prepareBuilder(rootObjectType);
    }

    private void prepareBuilder(IRepositoryObjectType objectType) {
        if (objectType != null) {
            this.populateConditionedTypeList(null, objectType);
        }
    }

    private void populateConditionedTypeList(ObjectTypeHandle parentHandler, IRepositoryObjectType objectType) {
        ObjectTypeHandle handler = new ObjectTypeHandle(parentHandler, objectType);
        if (handler.hasCondition()) {
            this.conditionedTypes.add(handler);
        }
        for (IRepositoryObjectType childType : objectType.getChildObjectTypes()) {
            this.populateConditionedTypeList(handler, childType);
        }
    }

    ObjectTypeHandle provide(IDataDescriptor metadata) {
        for (ObjectTypeHandle element : this.conditionedTypes) {
            if (!element.evalueCondition(metadata)) continue;
            return element;
        }
        return null;
    }
}

