/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.ecm.meta;

import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectProperty;
import com.cognos.cm.repository.plugin.configuration.RepositoryPropertyType;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IPropertyValueHandler;
import com.ibm.cognos.cm.ecm.cmis.CMISProperty;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyProvider;
import com.ibm.cognos.cm.ecm.cmis.CMISPropertyType;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PropertyBuilder {
    private static final char DEFAULT_CHAR_REPLACEMENT = ' ';
    private static final Map<RepositoryPropertyType, TypeMapping> TYPE_MAP = new HashMap<RepositoryPropertyType, TypeMapping>(RepositoryPropertyType.values().length);
    private final CMISPropertyProvider cmisPropProvider;
    private final Map<Character, Character> nameCharReplacementMap;

    PropertyBuilder(CMISPropertyProvider cmisPropProvider, Map<String, String> replacementMap) {
        this.cmisPropProvider = cmisPropProvider;
        this.nameCharReplacementMap = replacementMap != null ? PropertyBuilder.getCharacterReplacementMap(replacementMap) : Collections.emptyMap();
    }

    CMISProperty createProperty(IRepositoryObjectProperty typeProp, IDataDescriptor data) {
        IPropertyValueHandler valueHandler;
        Object value;
        RepositoryPropertyType propertyType = typeProp.getPropertyType();
        CMISProperty cmisProp = null;
        TypeMapping mapping = TYPE_MAP.get(propertyType);
        if (mapping != null && (value = (valueHandler = typeProp.getPropertyValueHandler()).getValue(data)) != null) {
            if (mapping.getClazz().isInstance(value)) {
                String propertyName = typeProp.getPropertyName();
                cmisProp = this.createProperty(propertyName, propertyName, mapping.getCmisType());
                this.addPropValue(cmisProp, value);
            } else {
                throw new IllegalStateException("invalid " + propertyType + " object");
            }
        }
        return cmisProp;
    }

    private void addPropValue(CMISProperty cmisProp, Object value) {
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            for (Object item : values) {
                cmisProp.addValue(item);
            }
        } else {
            Object propValue = value;
            if ("cmis:name".equals(cmisProp.getDefinitonID())) {
                propValue = this.replaceInvalidCharaters((String)value);
            }
            cmisProp.addValue(propValue);
        }
    }

    String replaceInvalidCharaters(String value) {
        char[] valueCharArray = value.toCharArray();
        int changeCount = 0;
        for (int idx = 0; idx < valueCharArray.length; ++idx) {
            char currentChar = valueCharArray[idx];
            if (!this.nameCharReplacementMap.containsKey(Character.valueOf(currentChar))) continue;
            Character replacementChar = this.nameCharReplacementMap.get(Character.valueOf(currentChar));
            valueCharArray[idx] = replacementChar.charValue();
            ++changeCount;
        }
        String newValue = changeCount > 0 ? new String(valueCharArray) : value;
        return newValue;
    }

    CMISProperty createProperty(String name, String definition, CMISPropertyType type) {
        return this.cmisPropProvider.createProperty(name, definition, type);
    }

    static Map<Character, Character> getCharacterReplacementMap(Map<String, String> replacementMap) {
        HashMap<Character, Character> characterReplacementMap = new HashMap<Character, Character>(replacementMap.size());
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            if (entry.getKey().length() <= 0) continue;
            Character value = Character.valueOf(' ');
            if (entry.getValue() != null && entry.getValue().length() > 0) {
                value = Character.valueOf(entry.getValue().charAt(0));
            }
            characterReplacementMap.put(Character.valueOf(entry.getKey().charAt(0)), value);
        }
        return characterReplacementMap;
    }

    static {
        TYPE_MAP.put(RepositoryPropertyType.STRING, new TypeMapping(CMISPropertyType.STRING, String.class));
        TYPE_MAP.put(RepositoryPropertyType.DATETIME, new TypeMapping(CMISPropertyType.DATETIME, Calendar.class));
        TYPE_MAP.put(RepositoryPropertyType.BOOLEAN, new TypeMapping(CMISPropertyType.BOOLEAN, Boolean.class));
        TYPE_MAP.put(RepositoryPropertyType.INTEGER, new TypeMapping(CMISPropertyType.INTEGER, Integer.class));
        TYPE_MAP.put(RepositoryPropertyType.STRINGLIST, new TypeMapping(CMISPropertyType.STRING, List.class));
    }

    private static class TypeMapping {
        private final CMISPropertyType cmisType;
        private final Class<?> clazz;

        TypeMapping(CMISPropertyType cmisType, Class<?> clazz) {
            this.cmisType = cmisType;
            this.clazz = clazz;
        }

        CMISPropertyType getCmisType() {
            return this.cmisType;
        }

        Class<?> getClazz() {
            return this.clazz;
        }
    }
}

