/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.system.SystemUtils;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

class CCLConfigProcessor {
    private static final Log log = LogFactory.getLog(CCLConfigProcessor.class);
    private Map<String, String> aliases = null;

    CCLConfigProcessor() {
    }

    public String getRootURI(ICCLConfiguration cclConfig, String aliasRootName) throws RepositoryException {
        String uri;
        this.validateAliasRootName(aliasRootName);
        if (this.aliases == null) {
            this.aliases = this.loadAliasRoots(cclConfig);
        }
        if (this.isInvalidURI(uri = this.aliases.get(aliasRootName))) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.invalidAliasRoot).param("aliasRoot", aliasRootName);
            throw new RepositoryException(msg);
        }
        return uri;
    }

    private void validateAliasRootName(String aliasRootName) throws RepositoryException {
        if (aliasRootName == null || aliasRootName.length() == 0) {
            throw new RepositoryException(new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.invalidConnectionString).addDetail(new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.missingAliasRoot)));
        }
    }

    private Map<String, String> loadAliasRoots(ICCLConfiguration cclConfig) throws RepositoryException {
        try {
            Element aliasRootsElem = cclConfig.getValueElement("aliasRoots", true);
            this.checkNotNull(aliasRootsElem);
            List items = aliasRootsElem.elements();
            this.checkNotNull(items);
            HashMap<String, String> aliasMap = new HashMap<String, String>(items.size());
            boolean isWindows = SystemUtils.isRunningWindows();
            for (Element item : items) {
                String aliasName = item.elementText("name");
                String path = this.getRootURI(aliasName, item, isWindows);
                aliasMap.put(aliasName, path);
            }
            return aliasMap;
        }
        catch (CCLConfigurationException e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToGetAliasRootsFromConfig);
            RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
            if (e.getMessage() != null) {
                newEx.addDetail(e.getMessage());
            }
            throw newEx;
        }
    }

    private void checkNotNull(Object o) throws RepositoryException {
        if (o == null) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToGetAliasRootsFromConfig);
            throw new RepositoryException(msg);
        }
    }

    private String getRootURI(String aliasRootName, Element aliasRootEntry, boolean isWindows) {
        String rootURI;
        if (isWindows) {
            rootURI = aliasRootEntry.elementText("windowsURI");
            if (this.isInvalidURI(rootURI)) {
                this.logInvalidURI(aliasRootName, FileSystemRepositoryErrors.FRP_OPF.missingWindowsURI);
            }
        } else {
            rootURI = aliasRootEntry.elementText("unixURI");
            if (this.isInvalidURI(rootURI)) {
                this.logInvalidURI(aliasRootName, FileSystemRepositoryErrors.FRP_OPF.missingUnixURI);
            }
        }
        return rootURI;
    }

    private boolean isInvalidURI(String rootURI) {
        return rootURI == null || rootURI.length() == 0;
    }

    private void logInvalidURI(String aliasRootName, Resource.Id osDependentMessageID) {
        if (log.isWarnEnabled()) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.invalidAliasRoot).param("aliasRoot", aliasRootName);
            msg.addDetail(osDependentMessageID);
            log.warn((Object)msg.formatAll(Locale.getDefault()));
        }
    }
}

