/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin;

import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.IRepositoryDataSizeCounter;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.QueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResultObjects;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchiveFactory;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemProvider;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemProviderImpl;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepository;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndex;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndexFactory;
import com.ibm.cognos.cm.fileSystemPlugin.io.FileOutput;
import com.ibm.cognos.cm.fileSystemPlugin.io.GraphicsDescriptorOutput;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.path.FileNameBuilder;
import com.ibm.cognos.cm.fileSystemPlugin.path.FilePathBuilder;
import com.ibm.cognos.cm.fileSystemPlugin.query.QueryProcessor;
import com.ibm.cognos.cm.fileSystemPlugin.query.VersionID;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemArchive {
    private static final Log log = LogFactory.getLog(FileSystemArchive.class);
    private FileSystemRepository repository;
    private IRepositoryConnectionConfiguration connectionConfiguration;
    private String aliasRoot;
    private FileSystemProvider fileSystem;
    private FileSystemArchiveFactory factory;
    private IRepositoryDataSizeCounter bytesCounter;
    private BurstIndexFactory burstIndexFactory;

    public FileSystemArchive(IRepositoryConnectionConfiguration connectionConfiguration, String aliasRoot, String repositoryLocationString, String subFolder, BurstIndexFactory burstIndexFactory) throws RepositoryException {
        this.connectionConfiguration = connectionConfiguration;
        this.aliasRoot = aliasRoot;
        this.repository = new FileSystemRepository(aliasRoot, repositoryLocationString, subFolder);
        this.fileSystem = new FileSystemProviderImpl();
        this.factory = new FileSystemArchiveFactory();
        this.burstIndexFactory = burstIndexFactory;
    }

    public void cleanData() throws RepositoryException {
        File[] reportFolders = new File(this.repository.getBaseRepositoryLocation()).listFiles();
        if (reportFolders != null) {
            for (int i = 0; i < reportFolders.length; ++i) {
                File reportFolder = new File(reportFolders[i].getAbsolutePath());
                this.fileSystem.deleteSubFolders(reportFolder);
                reportFolder.delete();
            }
        }
    }

    public IQueryResult queryObjects(String queryName, IQueryParameters parameters, Properties options) throws RepositoryException {
        QueryProcessor queryProcessor = new QueryProcessor(this);
        List<IDataDescriptor> archivesMetadata = queryProcessor.processQuery(queryName, parameters);
        QueryResultObjects objects = new QueryResultObjects(archivesMetadata);
        QueryResult result = new QueryResult((IQueryResultObjects)objects, false);
        return result;
    }

    public void addArchive(DescriptorProperties descriptorProps) throws RepositoryException {
        this.repository.validateState();
        List<String> dirPaths = this.getDirPaths(descriptorProps);
        for (String directory : dirPaths) {
            this.writeDocument(descriptorProps, directory);
        }
    }

    private List<String> getDirPaths(DescriptorProperties descriptorProps) throws RepositoryException {
        String dirPath = this.fileSystem.getDataDirectoryPath(this.repository.getBaseRepositoryLocation(), this.repository.getSubFolder(), descriptorProps);
        List<String> recipients = this.getRecipients(dirPath, descriptorProps);
        return this.getDirPathsForRecipients(dirPath, recipients);
    }

    private List<String> getRecipients(String dirPath, DescriptorProperties descriptorProps) throws RepositoryException {
        List<String> recipients = null;
        if (descriptorProps.isBurst()) {
            recipients = descriptorProps.getRecipientsList();
            BurstIndex index = this.burstIndexFactory.getBurstIndex(dirPath, descriptorProps);
            index.append(recipients);
        } else {
            recipients = new ArrayList<String>();
        }
        return recipients;
    }

    private void writeDocument(DescriptorProperties descriptorProps, String dirPath) throws RepositoryException {
        String docObjClass = descriptorProps.getDocumentObjectClass();
        if (this.isHtmlGraphic(docObjClass)) {
            dirPath = this.writeGraphic(descriptorProps, dirPath);
        } else {
            this.writeOther(descriptorProps, dirPath);
        }
        FileOutput data = this.factory.newDataOutput(dirPath, descriptorProps, this.bytesCounter != null);
        data.write();
        this.incrementBytesCounter(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)(docObjClass + " archived to " + dirPath));
        }
    }

    private void incrementBytesCounter(FileOutput data) {
        if (this.bytesCounter != null) {
            this.bytesCounter.increment(data.getBytesWritten());
        }
    }

    private void writeOther(DescriptorProperties props, String dirPath) throws RepositoryException {
        this.fileSystem.createDirectory(dirPath);
        if (props.hasPolicies()) {
            this.savePolicies(dirPath, props);
        }
        this.saveVersionMetadata(props);
        FileOutput descriptor = this.factory.newDataDescriptorOutput(dirPath, props);
        descriptor.write();
        if (props.hasSpecification()) {
            FileOutput spec = this.factory.newReportSpecificationOutput(dirPath, props, this.bytesCounter != null);
            spec.write();
            this.incrementBytesCounter(spec);
        }
        if (props.isBurst() && "HTML".equalsIgnoreCase(props.getFormat())) {
            FileSystemArchive.moveImageFiles(props.getReportOutputStoreID(), dirPath);
        }
    }

    private static void moveImageFiles(String outputID, String dirPath) {
        block3: {
            File fSrc;
            if (outputID != null && outputID.length() > 0 && (fSrc = new File(FilePathBuilder.getFilesDirectoryPath(FilePathBuilder.getVersionDirectoryPath(dirPath), outputID))).exists()) {
                File fDest = new File(FilePathBuilder.getFilesDirectoryPath(dirPath, outputID));
                try {
                    FileUtils.forceMkdir((File)fDest);
                    FileUtils.copyDirectory((File)fSrc, (File)fDest);
                    FileUtils.deleteDirectory((File)fSrc);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Error moving image files from " + fSrc.getAbsolutePath() + " to " + fDest.getAbsolutePath() + ": " + e.getMessage()));
                }
            }
        }
    }

    private String writeGraphic(DescriptorProperties descriptorProps, String dirPath) throws RepositoryException {
        dirPath = this.fileSystem.getFilesDirectoryPath(dirPath, descriptorProps.getReportOutputStoreID());
        this.fileSystem.createDirectory(dirPath);
        GraphicsDescriptorOutput descriptor = new GraphicsDescriptorOutput(dirPath, descriptorProps);
        descriptor.write();
        return dirPath;
    }

    private List<String> getDirPathsForRecipients(String dirPath, List<String> recipients) throws RepositoryException {
        ArrayList<String> dirPaths = new ArrayList<String>();
        if (recipients.size() == 0) {
            dirPaths.add(dirPath);
        } else {
            for (String recipient : recipients) {
                dirPaths.add(FilePathBuilder.getBurstDirectoryPath(dirPath, recipient));
            }
        }
        return dirPaths;
    }

    private void savePolicies(String dirPath, DescriptorProperties descriptorProps) throws RepositoryException {
        FileOutput policiesOutput = this.factory.newPolicyOutput(dirPath, descriptorProps);
        policiesOutput.write();
        String reportRootPath = this.fileSystem.getReportDirectoryPath(this.repository.getBaseRepositoryLocation(), this.repository.getSubFolder(), descriptorProps.getTenantID(), descriptorProps.getReportStoreID());
        FileOutput currentPoliciesOutput = this.factory.newPolicyOutput(reportRootPath, descriptorProps);
        currentPoliciesOutput.write();
    }

    private void saveVersionMetadata(DescriptorProperties descriptorProps) throws RepositoryException {
        VersionID versionID = new VersionID(descriptorProps);
        String rootPath = FilePathBuilder.getRepositoryRootDirectory(this.repository.getBaseRepositoryLocation(), this.repository.getSubFolder(), descriptorProps.getTenantID());
        File versionDescriptorFile = FileNameBuilder.getVersionDescriptorFile(rootPath, versionID);
        if (!this.fileSystem.exists(versionDescriptorFile)) {
            FileOutput versionDescriptorOutput = this.factory.newVersionDescriptorOutput(versionDescriptorFile.getParent(), descriptorProps);
            versionDescriptorOutput.write();
        }
    }

    private boolean isHtmlGraphic(String docObjClass) {
        return docObjClass.equals("graphic");
    }

    public String getArchiveLocationRoot(TenantID t) {
        return this.repository.getRepositoryLocation(t);
    }

    public void setRepository(FileSystemRepository repository) {
        this.repository = repository;
    }

    public IRepositoryConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public FileSystemRepository getRepository() {
        return this.repository;
    }

    public byte[] fetchReportAccessPolicies(String reportStoreID, TenantID tenantID) throws RepositoryException {
        String reportDirectoryPath = this.fileSystem.getReportDirectoryPath(this.repository.getBaseRepositoryLocation(), this.repository.getSubFolder(), tenantID, reportStoreID);
        String policiesFileName = this.fileSystem.getPoliciesFileName(reportStoreID);
        File reportDirectory = new File(reportDirectoryPath);
        if (this.fileSystem.exists(reportDirectory)) {
            File policiesFile = new File(reportDirectoryPath, policiesFileName);
            if (this.fileSystem.exists(policiesFile)) {
                return this.fileSystem.getFileBytes(policiesFile);
            }
            return new byte[0];
        }
        Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.archiveLocationDoesNotExist).param("archiveLocation", this.aliasRoot);
        throw new RepositoryException(msg);
    }

    void setFileSystemProvider(FileSystemProvider fsProvider) {
        this.fileSystem = fsProvider;
    }

    void setFactory(FileSystemArchiveFactory factory) {
        this.factory = factory;
    }

    public String getAliasRootName() {
        return this.aliasRoot;
    }

    public void setDataSizeCounter(IRepositoryDataSizeCounter counter) {
        this.bytesCounter = counter;
    }
}

