/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin;

import com.cognos.cm.repositoryPluginAPI.DataObject;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IGetDataResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FileSystemGetDataResults
implements IGetDataResults {
    private List<FileSystemDataResult> results = new ArrayList<FileSystemDataResult>();
    private int current = -1;

    public DataObject getDataObject() {
        return this.results.get(this.current).getDataObject();
    }

    public IDataDescriptor getMetadata() {
        return this.results.get(this.current).getDataDescriptor();
    }

    public boolean next() {
        int nextCurrent = this.current + 1;
        if (nextCurrent >= this.results.size()) {
            this.current = -1;
            return false;
        }
        this.current = nextCurrent;
        return true;
    }

    public void addItem(DataObject dataObject, IDataDescriptor metadata) {
        this.results.add(new FileSystemDataResult(dataObject, metadata));
    }

    public void sortResults() {
        Collections.sort(this.results, FileSystemDataResult.getInstance());
    }

    private static class FileSystemDataResult
    implements Comparable<FileSystemDataResult> {
        private static Comparator<FileSystemDataResult> instanceObj;
        private DataObject dataObject;
        private IDataDescriptor metadata;

        public FileSystemDataResult(DataObject dataObject, IDataDescriptor metadata) {
            this.dataObject = dataObject;
            this.metadata = metadata;
        }

        protected static Comparator<FileSystemDataResult> getInstance() {
            if (instanceObj != null) {
                instanceObj = FileSystemDataResult.getInstance();
            }
            return instanceObj;
        }

        public DataObject getDataObject() {
            return this.dataObject;
        }

        public IDataDescriptor getDataDescriptor() {
            return this.metadata;
        }

        @Override
        public int compareTo(FileSystemDataResult result2) {
            return this.getReportSearchPath(this).compareTo(this.getReportSearchPath(result2));
        }

        private String getReportSearchPath(FileSystemDataResult result2) {
            return result2.getDataDescriptor().getProperty("reportSearchPath").getStringValue();
        }
    }
}

