/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.system.SystemUtils;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.path.FilePathBuilder;
import java.io.File;
import java.net.URI;
import org.apache.commons.httpclient.util.URIUtil;

public class FileSystemRepository {
    private static final String EMPTY_STRING = "";
    private static final String FILE_PROTOCOL = "file";
    private String baseRepositoryLocation;
    private boolean isWindowsURI;
    private String subFolder;

    public FileSystemRepository(String aliasRoot, String baseRepositoryLocationString, String subFolder) throws RepositoryException {
        this(aliasRoot, baseRepositoryLocationString, subFolder, SystemUtils.isRunningWindows());
    }

    protected FileSystemRepository(String aliasRoot, String baseRepositoryLocationString, String subFolder, boolean isWindowsURI) throws RepositoryException {
        this.isWindowsURI = isWindowsURI;
        this.setRepositoryLocation(aliasRoot, baseRepositoryLocationString, subFolder);
    }

    private void setRepositoryLocation(String aliasRoot, String baseRepositoryLocation, String _subFolder) throws RepositoryException {
        String tmpBaseRepositoryLocation = this.processOldStyleURI(baseRepositoryLocation);
        URI uri = null;
        try {
            String encodedURI = URIUtil.encodePath((String)tmpBaseRepositoryLocation, (String)"UTF8");
            uri = URI.create(encodedURI);
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.malformedAliasRootURI).param("aliasRoot", aliasRoot);
            RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
            if (e.getMessage() != null) {
                newEx.addDetail(e.getMessage());
            }
            throw newEx;
        }
        this.validateSchema(uri);
        this.subFolder = this.validateSubFolderName(_subFolder);
        this.baseRepositoryLocation = this.extractFilePath(uri);
    }

    private String extractFilePath(URI uri) {
        StringBuilder repoLocationBuffer = new StringBuilder();
        String auth = uri.getAuthority();
        String path = uri.getPath();
        if (auth != null) {
            if (this.isWindowsURI) {
                if (auth.length() > 2 && auth.charAt(0) != '.' && auth.charAt(1) != ':') {
                    repoLocationBuffer.append("\\\\");
                }
            } else if (auth.charAt(0) != '.') {
                repoLocationBuffer.append("/");
            }
            repoLocationBuffer.append(auth);
        } else if (this.isWindowsURI && path.startsWith("/")) {
            path = path.substring(1);
        }
        repoLocationBuffer.append(path);
        return new File(repoLocationBuffer.toString()).getPath();
    }

    private String processOldStyleURI(String uri) {
        int indOfWinPathSep = uri.indexOf(92);
        if (indOfWinPathSep < 0) {
            return uri;
        }
        int indOfPath = 7;
        if (uri.charAt(indOfPath) == '/') {
            ++indOfPath;
        }
        StringBuilder newUri = new StringBuilder(uri.substring(0, indOfPath));
        if ((indOfWinPathSep == 7 || indOfWinPathSep == 8) && uri.charAt(indOfWinPathSep + 1) == '\\') {
            indOfPath += 2;
        }
        String tmp = uri.substring(indOfPath);
        newUri.append(tmp.replace('\\', '/'));
        return newUri.toString();
    }

    private void validateSchema(URI uri) throws RepositoryException {
        if (!FILE_PROTOCOL.equalsIgnoreCase(uri.getScheme())) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.archiveLocationInvalidScheme).param("schemeName", uri.getScheme());
            RepositoryException newEx = new RepositoryException(msg);
            throw newEx;
        }
    }

    private String validateSubFolderName(String subFolderName) throws RepositoryException {
        String folderName = EMPTY_STRING;
        if (FilePathBuilder.isValidDirectoryName(subFolderName)) {
            folderName = File.separatorChar == '\\' ? subFolderName.replace('/', File.separatorChar) : subFolderName.replace('\\', File.separatorChar);
            if (folderName.charAt(0) == File.separatorChar) {
                folderName = folderName.substring(1);
            }
        } else if (subFolderName != null && !subFolderName.isEmpty()) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.archiveRootPathInvalid).param("rootFolderName", subFolderName);
            RepositoryException newEx = new RepositoryException(msg);
            throw newEx;
        }
        return folderName;
    }

    public String getRepositoryLocation(TenantID t) {
        return FilePathBuilder.getRepositoryRootDirectory(this.baseRepositoryLocation, this.subFolder, t);
    }

    public String getBaseRepositoryLocation() {
        return this.baseRepositoryLocation;
    }

    public void validateState() throws RepositoryException {
        File baseDirectory = new File(this.baseRepositoryLocation);
        if (!baseDirectory.exists() || !baseDirectory.canWrite()) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.archiveLocationWriteFail).param("archiveLocation", this.baseRepositoryLocation);
            RepositoryException newEx = new RepositoryException(msg);
            newEx.addDetail((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToAddArchive);
            throw newEx;
        }
    }

    public String getSubFolder() {
        return this.subFolder;
    }
}

