/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public abstract class BurstIndex {
    private final File index;

    BurstIndex(File versionDirectory) throws RepositoryException {
        String filename = this.getFilename();
        this.index = new File(versionDirectory, filename);
        if (!this.index.getParentFile().exists()) {
            this.index.getParentFile().mkdirs();
            if (!this.index.getParentFile().exists()) {
                throw new RepositoryException(this.ioErrorMessage(FileSystemRepositoryErrors.FRP_OPF.fileNotFound));
            }
        }
    }

    protected abstract Log getLog();

    public synchronized void append(List<String> recipients) throws RepositoryException {
        if (recipients == null || recipients.size() == 0) {
            return;
        }
        FileOutputStream file = null;
        try {
            file = new FileOutputStream(this.index, true);
            IOUtils.writeLines(recipients, (String)IOUtils.LINE_SEPARATOR, (OutputStream)file, (Charset)Charsets.UTF_8);
            file.flush();
        }
        catch (IOException e) {
            try {
                throw new RepositoryException(this.ioErrorMessage(FileSystemRepositoryErrors.FRP_OPF.failedToWriteFile), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(file);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)file);
    }

    public Set<String> read() throws RepositoryException {
        FileInputStream file = null;
        try {
            file = FileUtils.openInputStream((File)this.index);
            List lines = IOUtils.readLines((InputStream)file, (Charset)Charsets.UTF_8);
            HashSet<String> hashSet = new HashSet<String>(lines);
            return hashSet;
        }
        catch (IOException e) {
            throw new RepositoryException(this.ioErrorMessage(FileSystemRepositoryErrors.FRP_OPF.failedToReadAndParseFile), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)file);
        }
    }

    private Message ioErrorMessage(Resource.Id id) {
        Message msg = new Message(id);
        if (this.getLog().isErrorEnabled()) {
            this.getLog().error((Object)msg.format(Locale.getDefault()));
            this.getLog().error((Object)("Index file path: " + this.index.getPath()));
        }
        return msg;
    }

    public boolean exists() {
        return this.index.exists() && this.index.getPath().indexOf(this.getFilename()) != -1;
    }

    protected File getVersionIDDirectory() {
        return this.index.getParentFile();
    }

    protected abstract String getFilename();

    public abstract Collection<String> getRecipients(Identity var1) throws RepositoryException;
}

