/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.io.FileInput;
import com.ibm.cognos.cm.repositoryplugincommon.io.MetadataDescriptorReader;
import com.ibm.cognos.cm.repositoryplugincommon.io.PropertyReader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import org.dom4j.Node;

public class DataDescriptorInput
extends FileInput {
    private final MetadataDescriptorReader metadataReader;
    private final FilenameFilter fileFilter;

    public DataDescriptorInput() {
        this(new MetadataDescriptorReader(), new FileSystemMetadataFilenameFilter());
    }

    DataDescriptorInput(MetadataDescriptorReader metadataReader) {
        this(metadataReader, FileSystemMetadataFilenameFilter.INSTANCE);
    }

    DataDescriptorInput(MetadataDescriptorReader metadataReader, FilenameFilter fileFilter) {
        this.metadataReader = metadataReader;
        this.metadataReader.registerPropertyReader("recipients", AsXMLPropertyReader.INSTANCE);
        this.fileFilter = fileFilter;
    }

    @Override
    public File[] readInFiles(File reportFolder) {
        File[] files = null;
        if (reportFolder.exists() && reportFolder.isDirectory()) {
            files = reportFolder.listFiles(this.fileFilter);
        }
        return files;
    }

    public Map<String, String> readMetadataFromFile(File file) throws RepositoryException {
        return this.metadataReader.readMetadata(file);
    }

    private static class AsXMLPropertyReader
    implements PropertyReader {
        static final PropertyReader INSTANCE = new AsXMLPropertyReader();

        private AsXMLPropertyReader() {
        }

        public String getPropertyValue(Node propertyNode) {
            return propertyNode.asXML();
        }
    }

    protected static class FileSystemMetadataFilenameFilter
    implements FilenameFilter {
        static final FilenameFilter INSTANCE = new FileSystemMetadataFilenameFilter();

        protected FileSystemMetadataFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith("_desc.xml.gz");
        }
    }
}

