/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.io.FileInput;
import com.ibm.cognos.cm.fileSystemPlugin.io.FileSystemFilenameFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class DataInput
extends FileInput {
    private String outputID;

    public DataInput(String metadataFileName) {
        this.outputID = this.getOutputIDFromFilename(metadataFileName);
    }

    private String getOutputIDFromFilename(String metadataFileName) {
        return metadataFileName.replace("_desc.xml", "");
    }

    @Override
    public File[] readInFiles(File reportFolder) {
        File[] files = null;
        if (reportFolder.exists() && reportFolder.isDirectory()) {
            FileSystemFilenameFilter filter = new FileSystemFilenameFilter(this.outputID);
            files = reportFolder.listFiles(filter);
        }
        return files;
    }

    public InputStream readOutputStreamFile(String fileName) throws RepositoryException {
        InputStream stream = this.createNewInputStream(fileName);
        this.logSuccessfulRead(fileName);
        return stream;
    }

    public InputStream createNewInputStream(String fileName) throws RepositoryException {
        try {
            return new GZIPInputStream(new FileInputStream(fileName));
        }
        catch (IOException e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToReadAndParseFile);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public File getOutputFile(File versionFolder) {
        File[] files = this.readInFiles(versionFolder);
        if (files == null || files.length == 0) {
            this.logFileDoesNotExist(this.outputID);
            return null;
        }
        return files[0];
    }
}

