/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.io.FileOutputBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public abstract class DataStreamOutput
extends FileOutputBase {
    private static final int EOF = -1;
    private InputStream inputStream;

    public DataStreamOutput(String dir) {
        this(dir, false);
    }

    public DataStreamOutput(String dir, boolean countBytes) {
        super(dir, countBytes);
    }

    @Override
    public void write() throws RepositoryException {
        if (this.inputStream == null) {
            return;
        }
        String pathName = this.getDirectory() + File.separatorChar + this.getName() + (this.getName().indexOf(".gz") != -1 ? "" : ".gz");
        File file = new File(pathName);
        if (file.exists()) {
            return;
        }
        try {
            this.setOutputStream(this.createFileOutputStream(file));
            this.write(this.getOutputStream());
            this.logFileWritten(pathName);
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToWriteFile);
            throw new RepositoryException(msg, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.inputStream);
            IOUtils.closeQuietly((OutputStream)this.getOutputStream());
        }
    }

    void write(OutputStream outputStream) throws IOException {
        if (this.getFileHeader() != null) {
            outputStream.write(this.getFileHeader().getBytes(Charsets.UTF_8));
        }
        byte[] inputData = new byte[32768];
        int nBytesRead = this.inputStream.read(inputData);
        while (nBytesRead != -1) {
            outputStream.write(inputData, 0, nBytesRead);
            nBytesRead = this.inputStream.read(inputData);
        }
    }

    void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

