/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.ibm.cognos.cm.fileSystemPlugin.io.DirectorySorter;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class SimpleDirectorySorter
implements DirectorySorter {
    public static final Comparator<File> ASCENDING_BY_NAME = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final Comparator<File> DESCENDING_BY_NAME = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName()) * -1;
        }
    };
    private Comparator<File> comparator;

    public SimpleDirectorySorter() {
        this(ASCENDING_BY_NAME);
    }

    public SimpleDirectorySorter(Comparator<File> comparator) {
        this.comparator = comparator;
    }

    @Override
    public File[] sortFiles(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            Arrays.sort(files, this.comparator);
        }
        return files;
    }
}

