/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cmutils.config.ConfigurableClassProperties;
import com.ibm.cognos.cm.fileSystemPlugin.io.SimpleDirectorySorter;
import com.ibm.cognos.cm.fileSystemPlugin.io.SoftLRUCacheWithTTL;
import java.io.File;
import java.util.Comparator;

public class SoftCachingDirectorySorter
extends SimpleDirectorySorter {
    private static final int cacheSize = SoftCachingDirectorySorter.getInteger("cacheSize", 100);
    private static final int timeToLive = SoftCachingDirectorySorter.getInteger("timeToLive", 60000);
    private static final int evictInterval = SoftCachingDirectorySorter.getInteger("evictInterval", 60000);
    private final SoftLRUCacheWithTTL<File, CachedDirectory> cache;

    private static int getInteger(String prop, int value) {
        return ConfigurableClassProperties.getInteger(SoftCachingDirectorySorter.class, (String)prop, (int)value);
    }

    public SoftCachingDirectorySorter() {
        this(ASCENDING_BY_NAME, cacheSize, timeToLive, evictInterval);
    }

    public SoftCachingDirectorySorter(Comparator<File> comparator) {
        this(comparator, cacheSize, timeToLive, evictInterval);
    }

    public SoftCachingDirectorySorter(Comparator<File> comparator, int size, int ttl, int evictInterval) {
        super(comparator);
        this.cache = new SoftLRUCacheWithTTL(size, ttl, evictInterval);
    }

    @Override
    public File[] sortFiles(File directory) {
        File[] files = this.getCachedFiles(directory);
        if (files == null && (files = super.sortFiles(directory)) != null) {
            this.putCachedFiles(directory, files);
        }
        return files;
    }

    private File[] getCachedFiles(File directory) {
        File[] files = null;
        CachedDirectory entry = this.cache.get(directory);
        if (entry != null && this.isConsistent(directory, entry)) {
            files = entry.getFiles();
        }
        return files;
    }

    private boolean isConsistent(File directory, CachedDirectory entry) {
        return entry.lastModified() == directory.lastModified();
    }

    private void putCachedFiles(File directory, File[] files) {
        CachedDirectory entry = new CachedDirectory(directory.lastModified(), files);
        this.cache.put(directory, entry);
    }

    protected void setTimeToLive(int ttl) {
        this.cache.setTimeToLive(ttl);
    }

    protected int getTimeToLive() {
        return this.cache.getTimeToLive();
    }

    private static class CachedDirectory {
        private long lastModified;
        private File[] files;

        CachedDirectory(long lastModified, File[] files) {
            this.lastModified = lastModified;
            this.files = files;
        }

        long lastModified() {
            return this.lastModified;
        }

        File[] getFiles() {
            return this.files;
        }
    }
}

